/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.quota;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.quota.QuotaLevel;
import com.alibaba.lindorm.client.quota.QuotaOpType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class QuotaConfig
extends VersionedObjectWithAttributes {
    public static final byte[] QUOTA_FAMILY = Bytes.toBytes("f");
    public static final byte[] QUOTA_UNIT_COLUMN = Bytes.toBytes("u");
    public static final byte[] QUOTA_VALUE_COLUMN_PREFIX = Bytes.toBytes("v.");
    private String name;
    private QuotaLevel level;
    private Map<QuotaOpType, Long> quota;
    private QuotaUnit unit;

    public QuotaConfig(String name, QuotaLevel level) {
        this(name, level, null, QuotaUnit.CU);
    }

    public QuotaConfig(String name, QuotaLevel level, long quota, QuotaUnit unit, QuotaOpType opType) {
        this.name = name;
        this.level = level;
        this.quota = new HashMap<QuotaOpType, Long>();
        this.quota.put(opType, quota);
        this.unit = unit;
    }

    public QuotaConfig(String name, QuotaLevel level, Map<QuotaOpType, Long> quota, QuotaUnit unit) {
        this.name = name;
        this.level = level;
        this.quota = quota;
        this.unit = unit;
    }

    public QuotaConfig() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QuotaLevel getLevel() {
        return this.level;
    }

    public void setLevel(QuotaLevel level) {
        this.level = level;
    }

    public Map<QuotaOpType, Long> getQuota() {
        return this.quota;
    }

    public void setQuota(Map<QuotaOpType, Long> quota) {
        this.quota = quota;
    }

    public QuotaUnit getUnit() {
        return this.unit;
    }

    public void setUnit(QuotaUnit unit) {
        this.unit = unit;
    }

    public long getQuota(QuotaOpType type) {
        return this.quota.get((Object)type);
    }

    @Override
    public String toString() {
        return "level=" + (Object)((Object)this.level) + ", name=" + this.name + ", quota=" + this.quota + ", unit=" + (Object)((Object)this.unit);
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.level.name());
        WritableUtils.writeString(out, this.name);
        WritableUtils.writeString(out, this.unit.name());
        if (this.quota != null) {
            WritableUtils.writeVInt(out, this.quota.size());
            for (Map.Entry<QuotaOpType, Long> entry : this.quota.entrySet()) {
                WritableUtils.writeString(out, entry.getKey().name());
                WritableUtils.writeVLong(out, entry.getValue());
            }
        } else {
            WritableUtils.writeVInt(out, 0);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.level = QuotaLevel.valueOf(WritableUtils.readString(in));
        this.name = WritableUtils.readString(in);
        this.unit = QuotaUnit.valueOf(WritableUtils.readString(in));
        this.quota = new HashMap<QuotaOpType, Long>();
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            this.quota.put(QuotaOpType.valueOf(WritableUtils.readString(in)), WritableUtils.readVLong(in));
        }
    }

    public static enum QuotaUnit {
        CU,
        BYTE;

    }
}

