/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.exporter;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ExporterConsumer
extends VersionedObjectWithAttributes
implements Comparable {
    private static final byte VERSION = 1;
    private String consumerId;
    private String consumerName;
    private String creator;
    private long createTime;
    private String extInfo;

    @Override
    protected byte getSupportedVersion() {
        return 1;
    }

    public ExporterConsumer() {
    }

    public ExporterConsumer(String consumerId, String consumerName) {
        this.consumerId = consumerId;
        this.consumerName = consumerName;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String getExtInfo() {
        return this.extInfo;
    }

    public void setExtInfo(String extInfo) {
        this.extInfo = extInfo;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.consumerId);
        WritableUtils.writeString(out, this.consumerName);
        out.writeLong(this.createTime);
        WritableUtils.writeString(out, this.creator == null ? "" : this.creator);
        WritableUtils.writeString(out, this.extInfo == null ? "" : this.extInfo);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.consumerId = WritableUtils.readString(in);
        this.consumerName = WritableUtils.readString(in);
        if (this.getVersion() == 1) {
            this.createTime = in.readLong();
            this.creator = WritableUtils.readString(in);
            this.extInfo = WritableUtils.readString(in);
        }
    }

    @Override
    public String toString() {
        return this.consumerId + " - " + this.consumerName;
    }

    public int compareTo(Object o) {
        if (!(o instanceof ExporterConsumer)) {
            return -1;
        }
        ExporterConsumer other = (ExporterConsumer)o;
        int ret = this.consumerId.compareTo(other.getConsumerId());
        if (ret != 0) {
            return ret;
        }
        return this.consumerName.compareTo(other.getConsumerName());
    }
}

