/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WColumnRangeFilter
extends WFilter {
    protected byte[] minColumn = null;
    protected boolean minColumnInclusive = true;
    protected byte[] maxColumn = null;
    protected boolean maxColumnInclusive = false;

    public WColumnRangeFilter() {
    }

    public WColumnRangeFilter(byte[] minColumn, boolean minColumnInclusive, byte[] maxColumn, boolean maxColumnInclusive) {
        this.minColumn = minColumn;
        this.minColumnInclusive = minColumnInclusive;
        this.maxColumn = maxColumn;
        this.maxColumnInclusive = maxColumnInclusive;
    }

    public boolean isMinColumnInclusive() {
        return this.minColumnInclusive;
    }

    public boolean isMaxColumnInclusive() {
        return this.maxColumnInclusive;
    }

    public byte[] getMinColumn() {
        return this.minColumn;
    }

    public boolean getMinColumnInclusive() {
        return this.minColumnInclusive;
    }

    public byte[] getMaxColumn() {
        return this.maxColumn;
    }

    public boolean getMaxColumnInclusive() {
        return this.maxColumnInclusive;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.minColumn == null);
        Bytes.writeByteArray(out, this.minColumn);
        out.writeBoolean(this.minColumnInclusive);
        out.writeBoolean(this.maxColumn == null);
        Bytes.writeByteArray(out, this.maxColumn);
        out.writeBoolean(this.maxColumnInclusive);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        boolean isMinColumnNull = in.readBoolean();
        this.minColumn = Bytes.readByteArray(in);
        if (isMinColumnNull) {
            this.minColumn = null;
        }
        this.minColumnInclusive = in.readBoolean();
        boolean isMaxColumnNull = in.readBoolean();
        this.maxColumn = Bytes.readByteArray(in);
        if (isMaxColumnNull) {
            this.maxColumn = null;
        }
        this.maxColumnInclusive = in.readBoolean();
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WColumnRangeFilter;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " " + (this.minColumnInclusive ? "[" : "(") + Bytes.toStringBinary(this.minColumn) + ", " + Bytes.toStringBinary(this.maxColumn) + (this.maxColumnInclusive ? "]" : ")");
    }
}

