/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.exception.DoNotRetryIOException;
import com.alibaba.lindorm.client.exception.NotServingRegionException;
import com.alibaba.lindorm.client.exception.RegionInRecoveryException;
import com.alibaba.lindorm.client.exception.StackTraceElementMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ExceptionUtils {
    public static final int MAX_RECORD_ERROR_SERVER = 3;
    public static final int MAX_RECORD_ERROR = 5;

    public static String getDesc(List<Throwable> ths) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Throwable t : ths) {
            sb.append(ExceptionUtils.stringifyException(t));
            if (i == 5) {
                sb.append("...total exceptions num=" + ths.size());
                break;
            }
            ++i;
        }
        return sb.toString();
    }

    public static Map<String, Integer> classifyExs(Map<String, List<Throwable>> exceptions) {
        HashMap<String, Integer> cls = new HashMap<String, Integer>();
        HashSet<String> uniqueExceptions = new HashSet<String>();
        if (exceptions != null) {
            for (Map.Entry<String, List<Throwable>> entry : exceptions.entrySet()) {
                String location = entry.getKey();
                List<Throwable> ths = entry.getValue();
                for (Throwable t : ths) {
                    String name = " location: " + location + ", name: " + t.getClass().getSimpleName();
                    if (t instanceof DoNotRetryIOException) {
                        name = name + ", detail: ";
                        name = name + ExceptionUtils.stringifyException(t);
                    } else if (t instanceof NotServingRegionException || t instanceof RegionInRecoveryException) {
                        uniqueExceptions.add(name);
                    } else if (!uniqueExceptions.contains(name)) {
                        uniqueExceptions.add(name);
                        name = name + ", detail: ";
                        name = name + ExceptionUtils.stringifyException(t);
                    }
                    Integer i = (Integer)cls.get(name);
                    if (i == null) {
                        i = 0;
                    }
                    i = i + 1;
                    cls.put(name, i);
                }
            }
        }
        return cls;
    }

    public static String getDesc(Map<String, Integer> classification, boolean isClient) {
        return ExceptionUtils.getDesc(classification, isClient, 0);
    }

    public static String getDesc(Map<String, Integer> classification, boolean isClient, int unrecoderdException) {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        sb.append(isClient ? "Client side Error:{ " : "Server side Error:{ ");
        for (Map.Entry<String, Integer> e : classification.entrySet()) {
            sb.append(e.getKey() + ": " + e.getValue() + ExceptionUtils.pluralize(e.getValue()) + ", ");
            if (i == 5) {
                sb.append("...total unique exceptions num=" + classification.keySet().size());
                break;
            }
            ++i;
        }
        if (unrecoderdException != 0) {
            sb.append("...unrecorded exceptions num=" + unrecoderdException);
        }
        sb.append("} \n");
        return sb.toString();
    }

    public static String pluralize(int c) {
        return c > 1 ? "times" : "time";
    }

    public static String stringifyException(Throwable t) {
        return StringUtils.stringifyException(t);
    }

    public static List<StackTraceElementMessage> toStackTraceElementMessages(StackTraceElement[] trace) {
        if (trace == null) {
            return null;
        }
        ArrayList<StackTraceElementMessage> pbTrace = new ArrayList<StackTraceElementMessage>(trace.length);
        for (StackTraceElement elem : trace) {
            StackTraceElementMessage stmessage = new StackTraceElementMessage();
            stmessage.setDeclaringClass(elem.getClassName());
            stmessage.setFileName(elem.getFileName());
            stmessage.setLineNumber(elem.getLineNumber());
            stmessage.setMethodName(elem.getMethodName());
            pbTrace.add(stmessage);
        }
        return pbTrace;
    }

    public static StackTraceElement[] toStackTrace(List<StackTraceElementMessage> traceList) {
        if (traceList == null || traceList.size() == 0) {
            return new StackTraceElement[0];
        }
        StackTraceElement[] trace = new StackTraceElement[traceList.size()];
        for (int i = 0; i < traceList.size(); ++i) {
            StackTraceElementMessage elem = traceList.get(i);
            trace[i] = new StackTraceElement(elem.getDeclaringClass(), elem.getMethodName(), elem.getFileName(), elem.getLineNumber());
        }
        return trace;
    }
}

