/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LFloat;
import com.alibaba.lindorm.client.core.types.LRealNumberType;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;

public class LUnsignedFloat
extends LRealNumberType<Float> {
    public static final LUnsignedFloat INSTANCE = new LUnsignedFloat();

    private LUnsignedFloat() {
        super(DataType.UNSIGNED_FLOAT, Float.class);
    }

    @Override
    public int getByteSize() {
        return 4;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return LFloat.INSTANCE.isCastableTo(targetType);
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return this.toBytes(value, SortOrder.getDefault());
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        byte[] ret = new byte[this.getByteSize()];
        DataTypeUtils.encodeUnsignedFloat(((Number)value).floatValue(), ret, 0, sortOrder);
        return ret;
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        float v = ((Float)LFloat.INSTANCE.toObject(value, actualType)).floatValue();
        if (v < 0.0f) {
            throw new IllegalDataException("Cannot set negative value for UNSIGNED_FLOAT type, actual value=" + v);
        }
        return Float.valueOf(v);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return this.toObject(value, 0, value.length, SortOrder.getDefault());
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        DataTypeUtils.checkForSufficientLength(length, this.getByteSize(), this.clientType);
        return Float.valueOf(DataTypeUtils.decodeUnsignedFloat(value, offset, sortOrder));
    }

    @Override
    public byte[] getNullValue() throws IllegalDataException {
        return this.toBytes(0);
    }
}

