/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.types;

import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LEncodedVarbinary;
import com.alibaba.lindorm.client.core.types.LVarbinary;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.util.Arrays;

public class LBinary
extends LDataType<byte[]> {
    public static final LBinary INSTANCE = new LBinary();

    private LBinary() {
        super(DataType.BINARY, byte[].class);
    }

    @Override
    public int getByteSize() {
        throw new UnsupportedOperationException("Please call LBinary#getByteSize(Object) instead.");
    }

    @Override
    public int getByteSize(Object obj) {
        return obj == null ? 0 : ((byte[])obj).length;
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public boolean isCastableTo(LDataType targetType) {
        return targetType == INSTANCE || targetType == LEncodedVarbinary.INSTANCE || targetType == LVarbinary.INSTANCE;
    }

    @Override
    public byte[] toBytes(Object value) throws IllegalDataException {
        return (byte[])value;
    }

    @Override
    public byte[] toBytes(Object value, SortOrder sortOrder) throws IllegalDataException {
        return LVarbinary.INSTANCE.toBytes(value, sortOrder);
    }

    @Override
    public Object toObject(Object value, LDataType actualType) throws IllegalDataException {
        return LVarbinary.INSTANCE.toObject(value, actualType);
    }

    @Override
    public Object toObject(byte[] value) throws IllegalDataException {
        return value;
    }

    @Override
    public Object toObject(byte[] value, int offset, int length, SortOrder sortOrder) throws IllegalDataException {
        return LVarbinary.INSTANCE.toObject(value, offset, length, sortOrder);
    }

    @Override
    public byte[] pad(byte[] value, int maxLength, SortOrder sortOrder) {
        if (value == null) {
            return null;
        }
        if (value.length < maxLength) {
            byte[] ret = new byte[maxLength];
            System.arraycopy(value, 0, ret, 0, value.length);
            if (sortOrder == SortOrder.DESC) {
                Arrays.fill(ret, value.length, maxLength, SchemaUtils.SEPARATOR_BYTE_DESC);
            }
            return ret;
        }
        return value;
    }

    @Override
    public byte[] getNullValue() throws IllegalDataException {
        byte[] ret = new byte[]{0};
        return this.toBytes(ret);
    }
}

