/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Attributes {
    public static String ROUTECACHEKEY = "CACHE";
    public static String SERVERBANLIST = "SERVER_BANLIST";
    public static String NEEDROUTE = "NEEDROUTE";
    public static String SINGLEIDC = "SINGLEIDC";
    public static String GLITCHTIME = "GLITCH";
    public static byte[] EMPTYVALUE = LindormClientConstants.EMPTY_BYTE_ARRAY;
    protected Map<String, byte[]> attributes = null;

    public void setAttribute(String name, String value) {
        this.setAttribute(name, Bytes.toBytes(value));
    }

    public void setAttribute(String name, byte[] value) {
        if (this.attributes == null && value == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, byte[]>();
        }
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        }
    }

    public byte[] getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public String getAttribute(String name, String defaultValue) {
        byte[] value = this.getAttribute(name);
        return value == null ? defaultValue : Bytes.toString(value);
    }

    public byte[] getAttribute(String name, byte[] defaultValue) {
        byte[] value = this.getAttribute(name);
        return value == null ? defaultValue : value;
    }

    public boolean hasAttribute(String name) {
        return this.attributes == null ? false : this.attributes.containsKey(name);
    }

    public Map<String, byte[]> getAttributesMap() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    protected void writeAttributes(DataOutput out) throws IOException {
        if (this.attributes == null || this.attributes.size() == 0) {
            WritableUtils.writeVInt(out, 0);
        } else {
            WritableUtils.writeVInt(out, this.attributes.size());
            for (Map.Entry<String, byte[]> attr : this.attributes.entrySet()) {
                WritableUtils.writeString(out, attr.getKey());
                Bytes.writeByteArray(out, attr.getValue());
            }
        }
    }

    protected void readAttributes(DataInput in) throws IOException {
        int numAttributes = WritableUtils.readVInt(in);
        if (numAttributes > 0) {
            this.attributes = new HashMap<String, byte[]>(numAttributes);
            for (int i = 0; i < numAttributes; ++i) {
                String name = WritableUtils.readString(in);
                byte[] value = Bytes.readByteArray(in);
                this.attributes.put(name, value);
            }
        }
    }

    public String attributesToString() {
        if (this.attributes != null) {
            StringBuilder ret = new StringBuilder();
            ret.append("[");
            for (Map.Entry<String, byte[]> entry : this.attributes.entrySet()) {
                ret.append(entry.getKey());
                ret.append(" => ");
                if (entry.getKey().equals(GLITCHTIME)) {
                    ret.append(Bytes.toInt(entry.getValue()));
                } else {
                    ret.append(Bytes.toStringBinary(entry.getValue()));
                }
                ret.append(",");
            }
            if (this.attributes.size() > 0) {
                ret.setLength(ret.length() - 1);
            }
            ret.append("]");
            return ret.toString();
        }
        return "[]";
    }

    public boolean equalsAttributes(Attributes other) {
        if (this.attributes == null) {
            return other.attributes == null;
        }
        if (other.attributes == null) {
            return false;
        }
        return Attributes.hashCode(this.attributes) == Attributes.hashCode(other.attributes);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Attributes)) {
            return false;
        }
        return this.equalsAttributes((Attributes)obj);
    }

    public String toString() {
        return this.attributesToString();
    }

    private static int hashCode(Map<String, byte[]> map) {
        int result = 0;
        for (Map.Entry<String, byte[]> entry : map.entrySet()) {
            result += entry.getKey().hashCode() ^ Arrays.hashCode(entry.getValue());
        }
        return result;
    }
}

