/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.expression.Expression;
import com.alibaba.lindorm.client.core.expression.ExpressionType;
import com.alibaba.lindorm.client.core.expression.ExpressionVisitor;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.types.LBoolean;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.ConditionParseConstants;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;

public abstract class AndOrExpression
extends ConditionList {
    private BitSet partialEvalState;
    protected List<Condition> conditions;
    protected ConditionList.LogicalOp operator;

    protected AndOrExpression(ConditionList.LogicalOp op) {
        this.operator = op;
    }

    @Override
    public ConditionList.LogicalOp getOp() {
        return this.operator;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public ConditionList add(Condition c) throws IllegalRequestException {
        AndOrExpression.validateChildrenCondition(c);
        if (this.conditions == null) {
            this.conditions = CollectionUtils.newArrayList();
        }
        this.conditions.add(c);
        return this;
    }

    protected static void validateChildrenConditions(List<? extends Expression> conditions) throws IllegalRequestException {
        if (conditions == null || conditions.size() == 0) {
            throw new IllegalRequestException("Found empty AND/OR condition list, you should add at least one condition.");
        }
    }

    protected static void validateChildrenConditions(Condition[] conditions) throws IllegalRequestException {
        if (conditions == null || conditions.length == 0) {
            throw new IllegalRequestException("Found empty AND/OR condition list, you should add at least one condition.");
        }
    }

    protected static void validateChildrenCondition(Expression child) throws IllegalRequestException {
        if (child == null) {
            throw new IllegalRequestException("Cannot add a null condition into AND/OR condition list.");
        }
    }

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        boolean isEvaluated = true;
        for (int i = 0; i < this.conditions.size(); ++i) {
            Expression child = this.conditions.get(i);
            if (this.partialEvalState != null && this.partialEvalState.get(i)) continue;
            if (child.evaluate(tuple, result)) {
                boolean tmp = (Boolean)LBoolean.INSTANCE.toObject(result.get(), result.getOffset(), result.getLength(), SortOrder.getDefault());
                if (this.isStopValue(tmp)) {
                    return true;
                }
                if (this.partialEvalState == null) continue;
                this.partialEvalState.set(i);
                continue;
            }
            isEvaluated = false;
        }
        return isEvaluated;
    }

    protected abstract boolean isStopValue(boolean var1);

    @Override
    public void reset() {
        if (this.partialEvalState == null) {
            this.partialEvalState = new BitSet(this.conditions.size());
        } else {
            this.partialEvalState.clear();
        }
        for (Expression expression : this.conditions) {
            expression.reset();
        }
    }

    @Override
    public void resetAll() {
        this.reset();
        for (Expression expression : this.conditions) {
            expression.resetAll();
        }
    }

    protected <T> List<T> acceptChildren(ExpressionVisitor<T> visitor, List<? extends Expression> children) throws LindormException {
        List results = Collections.emptyList();
        for (Expression expression : children) {
            Object r = expression.accept(visitor);
            if (results.isEmpty()) {
                results = CollectionUtils.newArrayListWithCapacity(children.size());
            }
            visitor.addElement(results, r);
        }
        return results;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("(");
        if (this.conditions != null) {
            for (int i = 0; i < this.conditions.size(); ++i) {
                Condition c = this.conditions.get(i);
                ret.append(c.toString());
                if (i == this.conditions.size() - 1 && i != 0) continue;
                ret.append(" ");
                ret.append(this.operator.toString());
                ret.append(" ");
            }
        }
        ret.append(")");
        return ret.toString();
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        AndOrExpression.validateChildrenConditions(this.conditions);
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.operator.ordinal());
        WritableUtils.writeVInt(out, this.conditions.size());
        for (Condition c : this.conditions) {
            WritableUtils.writeVInt(out, ExpressionType.getOrdinal(c));
            c.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.operator = ConditionList.LogicalOp.values()[WritableUtils.readVInt(in)];
        int numOfChildren = WritableUtils.readVInt(in);
        this.conditions = CollectionUtils.newArrayListWithCapacity(numOfChildren);
        for (int i = 0; i < numOfChildren; ++i) {
            Condition child = (Condition)ExpressionType.fromOrdinal(WritableUtils.readVInt(in));
            child.readFrom(in);
            this.conditions.add(child);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
        result = 31 * result + this.operator.hashCode();
        return result;
    }

    @Override
    public String toParseableString() {
        String opString = null;
        if (ConditionList.LogicalOp.AND.equals((Object)this.getOp())) {
            opString = Bytes.toString(ConditionParseConstants.AND);
        } else if (ConditionList.LogicalOp.OR.equals((Object)this.getOp())) {
            opString = Bytes.toString(ConditionParseConstants.OR);
        } else {
            throw new IllegalArgumentException("Unexpected LogicalOp:" + (Object)((Object)this.getOp()));
        }
        StringBuilder paseableString = new StringBuilder();
        if (!this.conditions.isEmpty()) {
            paseableString.append("(");
            paseableString.append(this.conditions.get(0).toParseableString());
            for (int i = 1; i < this.conditions.size(); ++i) {
                paseableString.append(" ");
                paseableString.append(opString);
                paseableString.append(" ");
                paseableString.append(this.conditions.get(i).toParseableString());
            }
            paseableString.append(")");
        }
        return paseableString.toString();
    }
}

