/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.webflux;

import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.adapter.reactor.ContextConfig;
import com.alibaba.csp.sentinel.adapter.reactor.EntryConfig;
import com.alibaba.csp.sentinel.adapter.reactor.SentinelReactorTransformer;
import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.WebFluxCallbackManager;
import java.util.Optional;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class SentinelWebFluxFilter
implements WebFilter {
    private static final String EMPTY_ORIGIN = "";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return chain.filter(exchange).transform(this.buildSentinelTransformer(exchange));
    }

    private SentinelReactorTransformer<Void> buildSentinelTransformer(ServerWebExchange exchange) {
        String path = exchange.getRequest().getPath().value();
        String finalPath = Optional.ofNullable(WebFluxCallbackManager.getUrlCleaner()).map(f -> (String)f.apply(exchange, path)).orElse(path);
        String origin = Optional.ofNullable(WebFluxCallbackManager.getRequestOriginParser()).map(f -> (String)f.apply(exchange)).orElse(EMPTY_ORIGIN);
        return new SentinelReactorTransformer(new EntryConfig(finalPath, EntryType.IN, new ContextConfig(finalPath, origin)));
    }
}

