/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.config.autoconfigure;

import com.alibaba.boot.nacos.config.autoconfigure.NacosConfigApplicationInitializer;
import com.alibaba.boot.nacos.config.properties.NacosConfigProperties;
import com.alibaba.boot.nacos.config.util.Function;
import com.alibaba.boot.nacos.config.util.NacosConfigPropertiesUtils;
import com.alibaba.boot.nacos.config.util.NacosConfigUtils;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.LinkedList;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class NacosConfigEnvironmentProcessor
implements EnvironmentPostProcessor {
    private final Logger logger = LoggerFactory.getLogger(EnvironmentPostProcessor.class);
    private final LinkedList<NacosConfigUtils.DeferNacosPropertySource> deferPropertySources = new LinkedList();
    private final Function<Properties, ConfigService> builder = new Function<Properties, ConfigService>(){

        @Override
        public ConfigService apply(Properties input) {
            try {
                return NacosFactory.createConfigService((Properties)input);
            }
            catch (NacosException e) {
                throw new RuntimeException("ConfigService can't be created with properties : " + input, e);
            }
        }
    };

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        application.addInitializers(new ApplicationContextInitializer[]{new NacosConfigApplicationInitializer(this)});
        if (this.enable((Environment)environment)) {
            System.out.println("[Nacos Config Boot] : The preload log configuration is enabled");
            this.initLogConfig(environment);
        }
    }

    private void initLogConfig(ConfigurableEnvironment environment) {
        NacosConfigProperties nacosConfigProperties = NacosConfigPropertiesUtils.buildNacosConfigProperties(environment);
        NacosConfigUtils configUtils = new NacosConfigUtils(nacosConfigProperties, environment, this.builder);
        configUtils.loadConfig(true);
        this.deferPropertySources.addAll(configUtils.getNacosPropertySources());
    }

    boolean enable(Environment environment) {
        return Boolean.parseBoolean(environment.getProperty("nacos.config.bootstrap.log.enable", "false"));
    }

    LinkedList<NacosConfigUtils.DeferNacosPropertySource> getDeferPropertySources() {
        return this.deferPropertySources;
    }
}

