/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.output;

import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.output.CommandOutput;
import com.lambdaworks.redis.output.OutputFactory;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

public class ArrayOutput<K, V>
extends CommandOutput<K, V, List<Object>> {
    private boolean initialized;
    private Deque<Integer> counts = new ArrayDeque<Integer>();
    private Deque<List<Object>> stack = new ArrayDeque<List<Object>>();

    public ArrayOutput(RedisCodec<K, V> codec) {
        super(codec, Collections.emptyList());
    }

    @Override
    public void set(ByteBuffer bytes) {
        if (bytes != null) {
            Object value = this.codec.decodeValue(bytes);
            this.stack.peek().add(value);
        }
    }

    @Override
    public void set(long integer) {
        this.stack.peek().add(integer);
    }

    @Override
    public void complete(int depth) {
        if (this.counts.isEmpty()) {
            return;
        }
        if (depth == this.stack.size() && this.stack.peek().size() == this.counts.peek().intValue()) {
            List<Object> pop = this.stack.pop();
            this.counts.pop();
            if (!this.stack.isEmpty()) {
                this.stack.peek().add(pop);
            }
        }
    }

    @Override
    public void multi(int count) {
        if (!this.initialized) {
            this.output = OutputFactory.newList(count);
            this.initialized = true;
        }
        if (this.stack.isEmpty()) {
            this.stack.push((List<Object>)this.output);
        } else {
            this.stack.push(OutputFactory.newList(count));
        }
        this.counts.push(count);
    }
}

