/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import jline.console.UserInterruptException;
import jline.console.history.History;
import sqlline.ColorBuffer;
import sqlline.CommandHandler;
import sqlline.DatabaseConnection;
import sqlline.DatabaseConnections;
import sqlline.DispatchCallback;
import sqlline.OutputFile;
import sqlline.SqlLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Commands {
    private static final String[] METHODS = new String[]{"allProceduresAreCallable", "allTablesAreSelectable", "dataDefinitionCausesTransactionCommit", "dataDefinitionIgnoredInTransactions", "doesMaxRowSizeIncludeBlobs", "getCatalogSeparator", "getCatalogTerm", "getDatabaseProductName", "getDatabaseProductVersion", "getDefaultTransactionIsolation", "getDriverMajorVersion", "getDriverMinorVersion", "getDriverName", "getDriverVersion", "getExtraNameCharacters", "getIdentifierQuoteString", "getMaxBinaryLiteralLength", "getMaxCatalogNameLength", "getMaxCharLiteralLength", "getMaxColumnNameLength", "getMaxColumnsInGroupBy", "getMaxColumnsInIndex", "getMaxColumnsInOrderBy", "getMaxColumnsInSelect", "getMaxColumnsInTable", "getMaxConnections", "getMaxCursorNameLength", "getMaxIndexLength", "getMaxProcedureNameLength", "getMaxRowSize", "getMaxSchemaNameLength", "getMaxStatementLength", "getMaxStatements", "getMaxTableNameLength", "getMaxTablesInSelect", "getMaxUserNameLength", "getNumericFunctions", "getProcedureTerm", "getSchemaTerm", "getSearchStringEscape", "getSQLKeywords", "getStringFunctions", "getSystemFunctions", "getTimeDateFunctions", "getURL", "getUserName", "isCatalogAtStart", "isReadOnly", "nullPlusNonNullIsNull", "nullsAreSortedAtEnd", "nullsAreSortedAtStart", "nullsAreSortedHigh", "nullsAreSortedLow", "storesLowerCaseIdentifiers", "storesLowerCaseQuotedIdentifiers", "storesMixedCaseIdentifiers", "storesMixedCaseQuotedIdentifiers", "storesUpperCaseIdentifiers", "storesUpperCaseQuotedIdentifiers", "supportsAlterTableWithAddColumn", "supportsAlterTableWithDropColumn", "supportsANSI92EntryLevelSQL", "supportsANSI92FullSQL", "supportsANSI92IntermediateSQL", "supportsBatchUpdates", "supportsCatalogsInDataManipulation", "supportsCatalogsInIndexDefinitions", "supportsCatalogsInPrivilegeDefinitions", "supportsCatalogsInProcedureCalls", "supportsCatalogsInTableDefinitions", "supportsColumnAliasing", "supportsConvert", "supportsCoreSQLGrammar", "supportsCorrelatedSubqueries", "supportsDataDefinitionAndDataManipulationTransactions", "supportsDataManipulationTransactionsOnly", "supportsDifferentTableCorrelationNames", "supportsExpressionsInOrderBy", "supportsExtendedSQLGrammar", "supportsFullOuterJoins", "supportsGroupBy", "supportsGroupByBeyondSelect", "supportsGroupByUnrelated", "supportsIntegrityEnhancementFacility", "supportsLikeEscapeClause", "supportsLimitedOuterJoins", "supportsMinimumSQLGrammar", "supportsMixedCaseIdentifiers", "supportsMixedCaseQuotedIdentifiers", "supportsMultipleResultSets", "supportsMultipleTransactions", "supportsNonNullableColumns", "supportsOpenCursorsAcrossCommit", "supportsOpenCursorsAcrossRollback", "supportsOpenStatementsAcrossCommit", "supportsOpenStatementsAcrossRollback", "supportsOrderByUnrelated", "supportsOuterJoins", "supportsPositionedDelete", "supportsPositionedUpdate", "supportsSchemasInDataManipulation", "supportsSchemasInIndexDefinitions", "supportsSchemasInPrivilegeDefinitions", "supportsSchemasInProcedureCalls", "supportsSchemasInTableDefinitions", "supportsSelectForUpdate", "supportsStoredProcedures", "supportsSubqueriesInComparisons", "supportsSubqueriesInExists", "supportsSubqueriesInIns", "supportsSubqueriesInQuantifieds", "supportsTableCorrelationNames", "supportsTransactions", "supportsUnion", "supportsUnionAll", "usesLocalFilePerTable", "usesLocalFiles"};
    private final SqlLine sqlLine;

    Commands(SqlLine sqlLine) {
        this.sqlLine = sqlLine;
    }

    public void metadata(String line, DispatchCallback callback) {
        this.sqlLine.debug(line);
        String[] parts = this.sqlLine.split(line);
        if (parts == null || parts.length == 0) {
            this.dbinfo("", callback);
            return;
        }
        LinkedList<Object> params = new LinkedList<Object>(Arrays.asList(parts));
        params.remove(0);
        params.remove(0);
        this.sqlLine.debug(((Object)params).toString());
        this.metadata(parts[1], params, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metadata(String cmd, List<Object> argList, DispatchCallback callback) {
        block11: {
            if (!this.sqlLine.assertConnection()) {
                callback.setToFailure();
                return;
            }
            try {
                Method[] methods = this.sqlLine.getDatabaseMetaData().getClass().getMethods();
                TreeSet<String> methodNames = new TreeSet<String>();
                TreeSet<String> methodNamesUpper = new TreeSet<String>();
                for (Method method : methods) {
                    methodNames.add(method.getName());
                    methodNamesUpper.add(method.getName().toUpperCase());
                }
                if (!methodNamesUpper.contains(cmd.toUpperCase())) {
                    this.sqlLine.error(this.sqlLine.loc("no-such-method", cmd));
                    this.sqlLine.error(this.sqlLine.loc("possible-methods", new Object[0]));
                    for (String methodName : methodNames) {
                        this.sqlLine.error("   " + methodName);
                    }
                    callback.setToFailure();
                    return;
                }
                Object res = this.sqlLine.getReflector().invoke((Object)this.sqlLine.getDatabaseMetaData(), DatabaseMetaData.class, cmd, argList);
                if (res instanceof ResultSet) {
                    ResultSet rs = (ResultSet)res;
                    try {
                        this.sqlLine.print(rs, callback);
                        break block11;
                    }
                    finally {
                        rs.close();
                    }
                }
                if (res != null) {
                    this.sqlLine.output(res.toString());
                }
            }
            catch (Exception e) {
                callback.setToFailure();
                this.sqlLine.error(e);
            }
        }
        callback.setToSuccess();
    }

    public void history(String line, DispatchCallback callback) {
        int index = 1;
        for (History.Entry entry : this.sqlLine.getConsoleReader().getHistory()) {
            this.sqlLine.output(this.sqlLine.getColorBuffer().pad(++index + ".", 6).append(entry.toString()));
        }
        callback.setToSuccess();
    }

    String arg1(String line, String paramName) {
        return this.arg1(line, paramName, null);
    }

    String arg1(String line, String paramName, String def) {
        String[] ret = this.sqlLine.split(line);
        if (ret == null || ret.length != 2) {
            if (def != null) {
                return def;
            }
            throw new IllegalArgumentException(this.sqlLine.loc("arg-usage", ret == null || ret.length == 0 ? "" : ret[0], paramName));
        }
        return ret[1];
    }

    private List<Object> buildMetadataArgs(String line, String paramName, String[] defaultValues) {
        String[] compound;
        ArrayList<Object> list = new ArrayList<Object>();
        String[][] ret = this.sqlLine.splitCompound(line);
        if (ret == null || ret.length != 2) {
            if (defaultValues[defaultValues.length - 1] == null) {
                throw new IllegalArgumentException(this.sqlLine.loc("arg-usage", ret == null || ret.length == 0 ? "" : ret[0][0], paramName));
            }
            compound = new String[]{};
        } else {
            compound = ret[1];
        }
        if (compound.length <= defaultValues.length) {
            list.addAll(Arrays.asList(defaultValues).subList(0, defaultValues.length - compound.length));
            list.addAll(Arrays.asList(compound));
        } else {
            list.addAll(Arrays.asList(compound).subList(0, defaultValues.length));
        }
        return list;
    }

    public void indexes(String line, DispatchCallback callback) throws Exception {
        String[] strings = new String[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        List<Object> args = this.buildMetadataArgs(line, "table name", strings);
        args.add(Boolean.FALSE);
        args.add(Boolean.TRUE);
        this.metadata("getIndexInfo", args, callback);
    }

    public void primarykeys(String line, DispatchCallback callback) throws Exception {
        String[] strings = new String[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        List<Object> args = this.buildMetadataArgs(line, "table name", strings);
        this.metadata("getPrimaryKeys", args, callback);
    }

    public void exportedkeys(String line, DispatchCallback callback) throws Exception {
        String[] strings = new String[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        List<Object> args = this.buildMetadataArgs(line, "table name", strings);
        this.metadata("getExportedKeys", args, callback);
    }

    public void importedkeys(String line, DispatchCallback callback) throws Exception {
        String[] strings = new String[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        List<Object> args = this.buildMetadataArgs(line, "table name", strings);
        this.metadata("getImportedKeys", args, callback);
    }

    public void procedures(String line, DispatchCallback callback) throws Exception {
        String[] strings = new String[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        List<Object> args = this.buildMetadataArgs(line, "procedure name pattern", strings);
        this.metadata("getProcedures", args, callback);
    }

    public void tables(String line, DispatchCallback callback) throws SQLException {
        String[] strings = new String[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        List<Object> args = this.buildMetadataArgs(line, "table name", strings);
        args.add(null);
        this.metadata("getTables", args, callback);
    }

    public void typeinfo(String line, DispatchCallback callback) throws Exception {
        this.metadata("getTypeInfo", Collections.<Object>emptyList(), callback);
    }

    public void nativesql(String sql, DispatchCallback callback) throws Exception {
        if (sql.startsWith("!")) {
            sql = sql.substring(1);
        }
        if (sql.startsWith("native")) {
            sql = sql.substring("native".length() + 1);
        }
        String nat = this.sqlLine.getConnection().nativeSQL(sql);
        this.sqlLine.output(nat);
        callback.setToSuccess();
    }

    public void columns(String line, DispatchCallback callback) throws SQLException {
        String[] strings = new String[]{this.sqlLine.getConnection().getCatalog(), null, "%"};
        List<Object> args = this.buildMetadataArgs(line, "table name", strings);
        args.add("%");
        this.metadata("getColumns", args, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropall(String line, DispatchCallback callback) {
        DatabaseConnection databaseConnection = this.sqlLine.getDatabaseConnection();
        if (databaseConnection == null || databaseConnection.getUrl() == null) {
            this.sqlLine.error(this.sqlLine.loc("no-current-connection", new Object[0]));
            callback.setToFailure();
            return;
        }
        try {
            String question = this.sqlLine.loc("really-drop-all", new Object[0]);
            if (!this.sqlLine.getConsoleReader().readLine(question).equals("y")) {
                this.sqlLine.error("abort-drop-all");
                callback.setToFailure();
                return;
            }
            LinkedList<String> cmds = new LinkedList<String>();
            ResultSet rs = this.sqlLine.getTables();
            try {
                while (rs.next()) {
                    cmds.add("DROP TABLE " + rs.getString("TABLE_NAME") + ";");
                }
            }
            finally {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (this.sqlLine.runCommands(cmds, callback) == cmds.size()) {
                callback.setToSuccess();
            } else {
                callback.setToFailure();
            }
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void reconnect(String line, DispatchCallback callback) {
        DatabaseConnection databaseConnection = this.sqlLine.getDatabaseConnection();
        if (databaseConnection == null || databaseConnection.getUrl() == null) {
            this.sqlLine.error(this.sqlLine.loc("no-current-connection", new Object[0]));
            callback.setToFailure();
            return;
        }
        this.sqlLine.info(this.sqlLine.loc("reconnecting", databaseConnection.getUrl()));
        try {
            databaseConnection.reconnect();
        }
        catch (Exception e) {
            this.sqlLine.error(e);
            callback.setToFailure();
            return;
        }
        callback.setToSuccess();
    }

    public void scan(String line, DispatchCallback callback) throws IOException {
        TreeSet<String> names = new TreeSet<String>();
        if (this.sqlLine.getDrivers() == null) {
            this.sqlLine.setDrivers(this.sqlLine.scanDrivers(line));
        }
        this.sqlLine.info(this.sqlLine.loc("drivers-found-count", this.sqlLine.getDrivers().size()));
        for (Driver driver : this.sqlLine.getDrivers()) {
            names.add(driver.getClass().getName());
        }
        ColorBuffer colorBuffer = this.sqlLine.getColorBuffer();
        this.sqlLine.output(colorBuffer.bold(colorBuffer.pad(this.sqlLine.loc("compliant", new Object[0]), 10).getMono()).bold(colorBuffer.pad(this.sqlLine.loc("jdbc-version", new Object[0]), 8).getMono()).bold(this.sqlLine.getColorBuffer(this.sqlLine.loc("driver-class", new Object[0])).getMono()));
        for (String name : names) {
            try {
                Driver driver = (Driver)Class.forName(name).newInstance();
                ColorBuffer msg = colorBuffer.pad(driver.jdbcCompliant() ? "yes" : "no", 10).pad(driver.getMajorVersion() + "." + driver.getMinorVersion(), 8).append(name);
                if (driver.jdbcCompliant()) {
                    this.sqlLine.output(msg);
                    continue;
                }
                this.sqlLine.output(colorBuffer.red(msg.getMono()));
            }
            catch (Throwable t) {
                this.sqlLine.output(colorBuffer.red(name));
            }
        }
        callback.setToSuccess();
    }

    public void save(String line, DispatchCallback callback) throws IOException {
        this.sqlLine.info(this.sqlLine.loc("saving-options", this.sqlLine.getOpts().getPropertiesFile()));
        this.sqlLine.getOpts().save();
        callback.setToSuccess();
    }

    public void load(String line, DispatchCallback callback) throws IOException {
        this.sqlLine.getOpts().load();
        this.sqlLine.info(this.sqlLine.loc("loaded-options", this.sqlLine.getOpts().getPropertiesFile()));
        callback.setToSuccess();
    }

    public void config(String line, DispatchCallback callback) {
        try {
            Properties props = this.sqlLine.getOpts().toProperties();
            TreeSet<String> keys = new TreeSet<String>(Commands.asMap(props).keySet());
            for (String key : keys) {
                this.sqlLine.output(this.sqlLine.getColorBuffer().green(this.sqlLine.getColorBuffer().pad(key.substring("sqlline.".length()), 20).getMono()).append(props.getProperty(key)));
            }
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
            return;
        }
        callback.setToSuccess();
    }

    public void set(String line, DispatchCallback callback) {
        if (line == null || line.trim().equals("set") || line.length() == 0) {
            this.config(null, callback);
            return;
        }
        String[] parts = this.sqlLine.split(line, 3, "Usage: set <key> <value>");
        if (parts == null) {
            callback.setToFailure();
            return;
        }
        String key = parts[1];
        String value = parts[2];
        boolean success = this.sqlLine.getOpts().set(key, value, false);
        if (success && this.sqlLine.getOpts().getAutoSave()) {
            try {
                this.sqlLine.getOpts().save();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        callback.setToSuccess();
    }

    private void reportResult(String action, long start, long end) {
        if (this.sqlLine.getOpts().getShowElapsedTime()) {
            this.sqlLine.info(action + " " + this.sqlLine.locElapsedTime(end - start));
        } else {
            this.sqlLine.info(action);
        }
    }

    public void commit(String line, DispatchCallback callback) throws SQLException {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if (!this.sqlLine.assertAutoCommit()) {
            callback.setToFailure();
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.sqlLine.getDatabaseConnection().connection.commit();
            long end = System.currentTimeMillis();
            this.sqlLine.showWarnings();
            this.reportResult(this.sqlLine.loc("commit-complete", new Object[0]), start, end);
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void rollback(String line, DispatchCallback callback) throws SQLException {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if (!this.sqlLine.assertAutoCommit()) {
            callback.setToFailure();
            return;
        }
        try {
            long start = System.currentTimeMillis();
            this.sqlLine.getDatabaseConnection().connection.rollback();
            long end = System.currentTimeMillis();
            this.sqlLine.showWarnings();
            this.reportResult(this.sqlLine.loc("rollback-complete", new Object[0]), start, end);
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void autocommit(String line, DispatchCallback callback) throws SQLException {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if (line.endsWith("on")) {
            this.sqlLine.getDatabaseConnection().connection.setAutoCommit(true);
        } else if (line.endsWith("off")) {
            this.sqlLine.getDatabaseConnection().connection.setAutoCommit(false);
        }
        this.sqlLine.showWarnings();
        this.sqlLine.autocommitStatus(this.sqlLine.getDatabaseConnection().connection);
        callback.setToSuccess();
    }

    public void dbinfo(String line, DispatchCallback callback) {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        this.sqlLine.showWarnings();
        int padlen = 50;
        for (String method : METHODS) {
            try {
                this.sqlLine.output(this.sqlLine.getColorBuffer().pad(method, padlen).append("" + this.sqlLine.getReflector().invoke((Object)this.sqlLine.getDatabaseMetaData(), method, new Object[0])));
            }
            catch (Exception e) {
                this.sqlLine.handleException(e);
            }
        }
        callback.setToSuccess();
    }

    public void verbose(String line, DispatchCallback callback) {
        this.sqlLine.info("verbose: on");
        this.set("set verbose true", callback);
    }

    public void outputformat(String line, DispatchCallback callback) {
        this.set("set " + line, callback);
    }

    public void brief(String line, DispatchCallback callback) {
        this.sqlLine.info("verbose: off");
        this.set("set verbose false", callback);
    }

    public void isolation(String line, DispatchCallback callback) throws SQLException {
        String isolDesc;
        int i;
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if (line.endsWith("TRANSACTION_NONE")) {
            i = 0;
        } else if (line.endsWith("TRANSACTION_READ_COMMITTED")) {
            i = 2;
        } else if (line.endsWith("TRANSACTION_READ_UNCOMMITTED")) {
            i = 1;
        } else if (line.endsWith("TRANSACTION_REPEATABLE_READ")) {
            i = 4;
        } else if (line.endsWith("TRANSACTION_SERIALIZABLE")) {
            i = 8;
        } else {
            callback.setToFailure();
            this.sqlLine.error("Usage: isolation <TRANSACTION_NONE | TRANSACTION_READ_COMMITTED | TRANSACTION_READ_UNCOMMITTED | TRANSACTION_REPEATABLE_READ | TRANSACTION_SERIALIZABLE>");
            return;
        }
        Connection connection = this.sqlLine.getDatabaseConnection().getConnection();
        connection.setTransactionIsolation(i);
        int isol = connection.getTransactionIsolation();
        switch (i) {
            case 0: {
                isolDesc = "TRANSACTION_NONE";
                break;
            }
            case 2: {
                isolDesc = "TRANSACTION_READ_COMMITTED";
                break;
            }
            case 1: {
                isolDesc = "TRANSACTION_READ_UNCOMMITTED";
                break;
            }
            case 4: {
                isolDesc = "TRANSACTION_REPEATABLE_READ";
                break;
            }
            case 8: {
                isolDesc = "TRANSACTION_SERIALIZABLE";
                break;
            }
            default: {
                isolDesc = "UNKNOWN";
            }
        }
        this.sqlLine.debug(this.sqlLine.loc("isolation-status", isolDesc));
        callback.setToSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void batch(String line, DispatchCallback callback) {
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        if (this.sqlLine.getBatch() == null) {
            this.sqlLine.setBatch(new LinkedList<String>());
            this.sqlLine.info(this.sqlLine.loc("batch-start", new Object[0]));
            callback.setToSuccess();
        } else {
            this.sqlLine.info(this.sqlLine.loc("running-batch", new Object[0]));
            try {
                this.sqlLine.runBatch(this.sqlLine.getBatch());
                callback.setToSuccess();
            }
            catch (Exception e) {
                callback.setToFailure();
                this.sqlLine.error(e);
            }
            finally {
                this.sqlLine.setBatch(null);
            }
        }
    }

    public void sql(String line, DispatchCallback callback) {
        this.execute(line, false, callback);
    }

    public void call(String line, DispatchCallback callback) {
        this.execute(line, true, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String line, boolean call, DispatchCallback callback) {
        String prefix;
        if (line == null || line.length() == 0) {
            callback.setStatus(DispatchCallback.Status.FAILURE);
            return;
        }
        try {
            while (!line.trim().endsWith(";")) {
                StringBuilder prompt = new StringBuilder(this.sqlLine.getPrompt());
                for (int i = 0; i < prompt.length() - 1; ++i) {
                    if (prompt.charAt(i) == '>') continue;
                    prompt.setCharAt(i, i % 2 == 0 ? (char)'.' : ' ');
                }
                String extra = this.sqlLine.getConsoleReader().readLine(prompt.toString());
                if (null != extra) {
                    if (this.sqlLine.isComment(extra)) continue;
                    line = line + SqlLine.getSeparator() + extra;
                    continue;
                }
                break;
            }
        }
        catch (UserInterruptException uie) {
            callback.setStatus(DispatchCallback.Status.CANCELED);
            this.sqlLine.output(this.sqlLine.loc("command-canceled", new Object[0]));
            return;
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        if (line.trim().endsWith(";")) {
            line = line.trim();
            line = line.substring(0, line.length() - 1);
        }
        if (!this.sqlLine.assertConnection()) {
            callback.setToFailure();
            return;
        }
        String sql = line;
        if (sql.startsWith("!")) {
            sql = sql.substring(1);
        }
        String string = prefix = call ? "call" : "sql";
        if (sql.startsWith(prefix)) {
            sql = sql.substring(prefix.length());
        }
        if (this.sqlLine.getBatch() != null) {
            this.sqlLine.getBatch().add(sql);
            callback.setToSuccess();
            return;
        }
        try {
            Statement stmnt = null;
            try {
                boolean hasResults;
                long start = System.currentTimeMillis();
                if (call) {
                    stmnt = this.sqlLine.getDatabaseConnection().connection.prepareCall(sql);
                    callback.trackSqlQuery(stmnt);
                    hasResults = ((CallableStatement)stmnt).execute();
                } else {
                    stmnt = this.sqlLine.createStatement();
                    callback.trackSqlQuery(stmnt);
                    hasResults = stmnt.execute(sql);
                    callback.setToSuccess();
                }
                this.sqlLine.showWarnings();
                this.sqlLine.showWarnings(stmnt.getWarnings());
                if (hasResults) {
                    do {
                        ResultSet rs = stmnt.getResultSet();
                        try {
                            int count = this.sqlLine.print(rs, callback);
                            long end = System.currentTimeMillis();
                            this.reportResult(this.sqlLine.loc("rows-selected", count), start, end);
                        }
                        finally {
                            rs.close();
                        }
                    } while (SqlLine.getMoreResults(stmnt));
                } else {
                    int count = stmnt.getUpdateCount();
                    long end = System.currentTimeMillis();
                    this.reportResult(this.sqlLine.loc("rows-affected", count), start, end);
                }
            }
            finally {
                if (stmnt != null) {
                    this.sqlLine.showWarnings(stmnt.getWarnings());
                    stmnt.close();
                }
            }
        }
        catch (UserInterruptException uie) {
            callback.setStatus(DispatchCallback.Status.CANCELED);
            this.sqlLine.output(this.sqlLine.loc("command-canceled", new Object[0]));
            return;
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
            return;
        }
        this.sqlLine.showWarnings();
        callback.setToSuccess();
    }

    public void quit(String line, DispatchCallback callback) {
        this.sqlLine.setExit(true);
        this.close(null, callback);
    }

    public void closeall(String line, DispatchCallback callback) {
        this.close(null, callback);
        if (callback.isSuccess()) {
            while (callback.isSuccess()) {
                this.close(null, callback);
            }
            callback.setToSuccess();
        }
        callback.setToFailure();
    }

    public void close(String line, DispatchCallback callback) {
        DatabaseConnection databaseConnection = this.sqlLine.getDatabaseConnection();
        if (databaseConnection == null) {
            callback.setToFailure();
            return;
        }
        try {
            Connection connection = databaseConnection.getConnection();
            if (connection != null && !connection.isClosed()) {
                this.sqlLine.info(this.sqlLine.loc("closing", connection.getClass().getName()));
                connection.close();
            } else {
                this.sqlLine.info(this.sqlLine.loc("already-closed", new Object[0]));
            }
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
            return;
        }
        this.sqlLine.getDatabaseConnections().remove();
        callback.setToSuccess();
    }

    public void properties(String line, DispatchCallback callback) throws Exception {
        String example = "";
        example = example + "Usage: properties <properties file>" + SqlLine.getSeparator();
        String[] parts = this.sqlLine.split(line);
        if (parts.length < 2) {
            callback.setToFailure();
            this.sqlLine.error(example);
            return;
        }
        int successes = 0;
        for (int i = 1; i < parts.length; ++i) {
            Properties props = new Properties();
            props.load(new FileInputStream(parts[i]));
            this.connect(props, callback);
            if (!callback.isSuccess()) continue;
            ++successes;
        }
        if (successes != parts.length - 1) {
            callback.setToFailure();
        } else {
            callback.setToSuccess();
        }
    }

    public void connect(String line, DispatchCallback callback) throws Exception {
        String example = "Usage: connect <url> <username> <password> [driver]" + SqlLine.getSeparator();
        String[] parts = this.sqlLine.split(line);
        if (parts == null) {
            callback.setToFailure();
            return;
        }
        if (parts.length < 2) {
            callback.setToFailure();
            this.sqlLine.error(example);
            return;
        }
        String url = parts.length < 2 ? null : parts[1];
        String user = parts.length < 3 ? null : parts[2];
        String pass = parts.length < 4 ? null : parts[3];
        String driver = parts.length < 5 ? null : parts[4];
        Properties props = new Properties();
        if (url != null) {
            props.setProperty("url", url);
        }
        if (driver != null) {
            props.setProperty("driver", driver);
        }
        if (user != null) {
            props.setProperty("user", user);
        }
        if (pass != null) {
            props.setProperty("password", pass);
        }
        this.connect(props, callback);
    }

    private String getProperty(Properties props, String ... keys) {
        for (String key : keys) {
            String val = props.getProperty(key);
            if (val == null) continue;
            return val;
        }
        for (String key : Commands.asMap(props).keySet()) {
            for (String key1 : keys) {
                if (!key.endsWith(key1)) continue;
                return props.getProperty(key);
            }
        }
        return null;
    }

    public void connect(Properties props, DispatchCallback callback) throws IOException {
        String url = this.getProperty(props, "url", "javax.jdo.option.ConnectionURL", "ConnectionURL");
        String driver = this.getProperty(props, "driver", "javax.jdo.option.ConnectionDriverName", "ConnectionDriverName");
        String username = this.getProperty(props, "user", "javax.jdo.option.ConnectionUserName", "ConnectionUserName");
        String password = this.getProperty(props, "password", "javax.jdo.option.ConnectionPassword", "ConnectionPassword");
        if (url == null || url.length() == 0) {
            callback.setToFailure();
            this.sqlLine.error("Property \"url\" is required");
            return;
        }
        if (!(driver != null && driver.length() != 0 || this.sqlLine.scanForDriver(url))) {
            callback.setToFailure();
            this.sqlLine.error(this.sqlLine.loc("no-driver", url));
            return;
        }
        this.sqlLine.debug("Connecting to " + url);
        if (username == null) {
            username = this.sqlLine.getConsoleReader().readLine("Enter username for " + url + ": ");
        }
        if (password == null) {
            password = this.sqlLine.getConsoleReader().readLine("Enter password for " + url + ": ", Character.valueOf('*'));
        }
        try {
            this.sqlLine.getDatabaseConnections().setConnection(new DatabaseConnection(this.sqlLine, driver, url, username, password));
            this.sqlLine.getDatabaseConnection().getConnection();
            this.sqlLine.setCompletions();
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void rehash(String line, DispatchCallback callback) {
        try {
            if (!this.sqlLine.assertConnection()) {
                callback.setToFailure();
            }
            if (this.sqlLine.getDatabaseConnection() != null) {
                this.sqlLine.getDatabaseConnection().setCompletions(false);
            }
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void list(String line, DispatchCallback callback) {
        int index = 0;
        DatabaseConnections databaseConnections = this.sqlLine.getDatabaseConnections();
        this.sqlLine.info(this.sqlLine.loc("active-connections", databaseConnections.size()));
        for (DatabaseConnection databaseConnection : databaseConnections) {
            boolean closed;
            try {
                closed = databaseConnection.connection.isClosed();
            }
            catch (Exception e) {
                closed = true;
            }
            this.sqlLine.output(this.sqlLine.getColorBuffer().pad(" #" + index++ + "", 5).pad(closed ? this.sqlLine.loc("closed", new Object[0]) : this.sqlLine.loc("open", new Object[0]), 9).append(databaseConnection.getUrl()));
        }
        callback.setToSuccess();
    }

    public void all(String line, DispatchCallback callback) {
        int index = this.sqlLine.getDatabaseConnections().getIndex();
        boolean success = true;
        for (int i = 0; i < this.sqlLine.getDatabaseConnections().size(); ++i) {
            this.sqlLine.getDatabaseConnections().setIndex(i);
            this.sqlLine.output(this.sqlLine.loc("executing-con", this.sqlLine.getDatabaseConnection()));
            this.sql(line.substring("all ".length()), callback);
            success = callback.isSuccess() && success;
        }
        this.sqlLine.getDatabaseConnections().setIndex(index);
        if (success) {
            callback.setToSuccess();
        } else {
            callback.setToFailure();
        }
    }

    public void go(String line, DispatchCallback callback) {
        String[] parts = this.sqlLine.split(line, 2, "Usage: go <connection index>");
        if (parts == null) {
            callback.setToFailure();
            return;
        }
        int index = Integer.parseInt(parts[1]);
        if (!this.sqlLine.getDatabaseConnections().setIndex(index)) {
            this.sqlLine.error(this.sqlLine.loc("invalid-connection", "" + index));
            this.list("", callback);
            callback.setToFailure();
            return;
        }
        callback.setToSuccess();
    }

    public void script(String line, DispatchCallback callback) {
        if (this.sqlLine.getScriptOutputFile() == null) {
            this.startScript(line, callback);
        } else {
            this.stopScript(line, callback);
        }
    }

    private void stopScript(String line, DispatchCallback callback) {
        try {
            this.sqlLine.getScriptOutputFile().close();
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        this.sqlLine.output(this.sqlLine.loc("script-closed", this.sqlLine.getScriptOutputFile()));
        this.sqlLine.setScriptOutputFile(null);
        callback.setToSuccess();
    }

    private void startScript(String line, DispatchCallback callback) {
        OutputFile outFile = this.sqlLine.getScriptOutputFile();
        if (outFile != null) {
            callback.setToFailure();
            this.sqlLine.error(this.sqlLine.loc("script-already-running", outFile));
            return;
        }
        String[] parts = this.sqlLine.split(line, 2, "Usage: script <filename>");
        if (parts == null) {
            callback.setToFailure();
            return;
        }
        try {
            outFile = new OutputFile(parts[1]);
            this.sqlLine.setScriptOutputFile(outFile);
            this.sqlLine.output(this.sqlLine.loc("script-started", outFile));
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String line, DispatchCallback callback) {
        String[] parts = this.sqlLine.split(line, 2, "Usage: run <scriptfile>");
        if (parts == null) {
            callback.setToFailure();
            return;
        }
        LinkedList<String> cmds = new LinkedList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(parts[1]));
            try {
                String scriptLine;
                StringBuilder cmd = null;
                while ((scriptLine = reader.readLine()) != null) {
                    String trimmedLine = scriptLine.trim();
                    if (this.sqlLine.getOpts().getTrimScripts()) {
                        scriptLine = trimmedLine;
                    }
                    if (cmd != null) {
                        cmd.append(" \n");
                        cmd.append(scriptLine);
                        if (!trimmedLine.endsWith(";")) continue;
                        cmds.add(cmd.toString());
                        cmd = null;
                        continue;
                    }
                    if (this.sqlLine.needsContinuation(scriptLine)) {
                        cmd = new StringBuilder(scriptLine);
                        continue;
                    }
                    cmds.add(scriptLine);
                }
                if (cmd != null) {
                    cmd.append(";");
                    cmds.add(cmd.toString());
                }
            }
            finally {
                reader.close();
            }
            if (this.sqlLine.runCommands(cmds, callback) == cmds.size()) {
                callback.setToSuccess();
            } else {
                callback.setToFailure();
            }
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void record(String line, DispatchCallback callback) {
        if (this.sqlLine.getRecordOutputFile() == null) {
            this.startRecording(line, callback);
        } else {
            this.stopRecording(line, callback);
        }
    }

    private void stopRecording(String line, DispatchCallback callback) {
        try {
            this.sqlLine.getRecordOutputFile().close();
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
        this.sqlLine.output(this.sqlLine.loc("record-closed", this.sqlLine.getRecordOutputFile()));
        this.sqlLine.setRecordOutputFile(null);
        callback.setToSuccess();
    }

    private void startRecording(String line, DispatchCallback callback) {
        OutputFile outputFile = this.sqlLine.getRecordOutputFile();
        if (outputFile != null) {
            callback.setToFailure();
            this.sqlLine.error(this.sqlLine.loc("record-already-running", outputFile));
            return;
        }
        String[] parts = this.sqlLine.split(line, 2, "Usage: record <filename>");
        if (parts == null) {
            callback.setToFailure();
            return;
        }
        try {
            outputFile = new OutputFile(parts[1]);
            this.sqlLine.setRecordOutputFile(outputFile);
            this.sqlLine.output(this.sqlLine.loc("record-started", outputFile));
            callback.setToSuccess();
        }
        catch (Exception e) {
            callback.setToFailure();
            this.sqlLine.error(e);
        }
    }

    public void describe(String line, DispatchCallback callback) throws SQLException {
        String[][] cmd = this.sqlLine.splitCompound(line);
        if (cmd.length != 2) {
            this.sqlLine.error("Usage: describe <table name>");
            callback.setToFailure();
            return;
        }
        if (cmd[1].length == 1 && cmd[1][0] != null && cmd[1][0].equalsIgnoreCase("tables")) {
            this.tables("tables", callback);
        } else {
            this.columns(line, callback);
        }
    }

    public void help(String line, DispatchCallback callback) {
        String[] parts = this.sqlLine.split(line);
        String cmd = parts.length > 1 ? parts[1] : "";
        TreeSet<ColorBuffer> clist = new TreeSet<ColorBuffer>();
        for (CommandHandler commandHandler : this.sqlLine.commandHandlers) {
            if (cmd.length() != 0 && !commandHandler.getNames().contains(cmd)) continue;
            String help = commandHandler.getHelpText();
            if (!help.contains("\n ")) {
                help = this.sqlLine.wrap(help, 60, 20);
            }
            clist.add(this.sqlLine.getColorBuffer().pad("!" + commandHandler.getName(), 20).append(help));
        }
        for (ColorBuffer c : clist) {
            this.sqlLine.output(c);
        }
        if (cmd.length() == 0) {
            this.sqlLine.output("");
            this.sqlLine.output(this.sqlLine.loc("comments", SqlLine.getApplicationContactInformation()));
        }
        callback.setToSuccess();
    }

    public void manual(String line, DispatchCallback callback) throws IOException {
        String man;
        InputStream in = SqlLine.class.getResourceAsStream("manual.txt");
        if (in == null) {
            callback.setToFailure();
            this.sqlLine.error(this.sqlLine.loc("no-manual", new Object[0]));
            return;
        }
        BufferedReader breader = new BufferedReader(new InputStreamReader(in));
        int index = 0;
        while ((man = breader.readLine()) != null) {
            this.sqlLine.output(man);
            if (++index % (this.sqlLine.getOpts().getMaxHeight() - 1) != 0) continue;
            String prompt = this.sqlLine.loc("enter-for-more", new Object[0]);
            String ret = this.sqlLine.getConsoleReader().readLine(prompt);
            if (ret == null || !ret.startsWith("q")) continue;
            break;
        }
        breader.close();
        callback.setToSuccess();
    }

    static Map<String, String> asMap(Properties properties) {
        return properties;
    }
}

