/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.utility;

import java.util.regex.Pattern;
import org.testcontainers.shaded.com.google.common.net.HostAndPort;

public final class DockerImageName {
    private static final String ALPHA_NUMERIC = "[a-z0-9]+";
    private static final String SEPARATOR = "([\\.]{1}|_{1,2}|-+)";
    private static final String REPO_NAME_PART = "[a-z0-9]+(([\\.]{1}|_{1,2}|-+)[a-z0-9]+)*";
    private static final Pattern REPO_NAME = Pattern.compile("[a-z0-9]+(([\\.]{1}|_{1,2}|-+)[a-z0-9]+)*(/[a-z0-9]+(([\\.]{1}|_{1,2}|-+)[a-z0-9]+)*)*");
    private final String rawName;
    private final String registry;
    private final String repo;
    private final Versioning versioning;

    public DockerImageName(String name) {
        String remoteName;
        this.rawName = name;
        int slashIndex = name.indexOf(47);
        if (slashIndex == -1 || !name.substring(0, slashIndex).contains(".") && !name.substring(0, slashIndex).contains(":") && !name.substring(0, slashIndex).equals("localhost")) {
            this.registry = "";
            remoteName = name;
        } else {
            this.registry = name.substring(0, slashIndex);
            remoteName = name.substring(slashIndex + 1);
        }
        if (remoteName.contains("@sha256:")) {
            this.repo = remoteName.split("@sha256:")[0];
            this.versioning = new Sha256Versioning(remoteName.split("@sha256:")[1]);
        } else if (remoteName.contains(":")) {
            this.repo = remoteName.split(":")[0];
            this.versioning = new TagVersioning(remoteName.split(":")[1]);
        } else {
            this.repo = remoteName;
            this.versioning = new TagVersioning("latest");
        }
    }

    public DockerImageName(String name, String tag) {
        String remoteName;
        this.rawName = name;
        int slashIndex = name.indexOf(47);
        if (slashIndex == -1 || !name.substring(0, slashIndex).contains(".") && !name.substring(0, slashIndex).contains(":") && !name.substring(0, slashIndex).equals("localhost")) {
            this.registry = "";
            remoteName = name;
        } else {
            this.registry = name.substring(0, slashIndex - 1);
            remoteName = name.substring(slashIndex + 1);
        }
        if (tag.startsWith("sha256:")) {
            this.repo = remoteName;
            this.versioning = new Sha256Versioning(tag);
        } else {
            this.repo = remoteName;
            this.versioning = new TagVersioning(tag);
        }
    }

    public String getUnversionedPart() {
        if (!"".equals(this.registry)) {
            return this.registry + "/" + this.repo;
        }
        return this.repo;
    }

    public String getVersionPart() {
        return this.versioning.toString();
    }

    public String toString() {
        if (this.versioning == null) {
            return this.getUnversionedPart();
        }
        return this.getUnversionedPart() + this.versioning.getSeparator() + this.versioning.toString();
    }

    public void assertValid() {
        HostAndPort.fromString(this.registry);
        if (!REPO_NAME.matcher(this.repo).matches()) {
            throw new IllegalArgumentException(this.repo + " is not a valid Docker image name (in " + this.rawName + ")");
        }
        if (this.versioning == null) {
            throw new IllegalArgumentException("No image tag was specified in docker image name (" + this.rawName + "). Please provide a tag; this may be 'latest' or a specific version");
        }
        if (!this.versioning.isValid()) {
            throw new IllegalArgumentException(this.versioning + " is not a valid image versioning identifier (in " + this.rawName + ")");
        }
    }

    public String getRegistry() {
        return this.registry;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DockerImageName)) {
            return false;
        }
        DockerImageName other = (DockerImageName)o;
        String this$registry = this.getRegistry();
        String other$registry = other.getRegistry();
        if (this$registry == null ? other$registry != null : !this$registry.equals(other$registry)) {
            return false;
        }
        String this$repo = this.repo;
        String other$repo = other.repo;
        if (this$repo == null ? other$repo != null : !this$repo.equals(other$repo)) {
            return false;
        }
        Versioning this$versioning = this.versioning;
        Versioning other$versioning = other.versioning;
        return !(this$versioning == null ? other$versioning != null : !this$versioning.equals(other$versioning));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : $registry.hashCode());
        String $repo = this.repo;
        result = result * 59 + ($repo == null ? 43 : $repo.hashCode());
        Versioning $versioning = this.versioning;
        result = result * 59 + ($versioning == null ? 43 : $versioning.hashCode());
        return result;
    }

    private class Sha256Versioning
    implements Versioning {
        public static final String HASH_REGEX = "[0-9a-fA-F]{32,}";
        private final String hash;

        Sha256Versioning(String hash) {
            this.hash = hash;
        }

        @Override
        public boolean isValid() {
            return this.hash.matches(HASH_REGEX);
        }

        @Override
        public String getSeparator() {
            return "@";
        }

        public String toString() {
            return "sha256:" + this.hash;
        }

        public String getHash() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sha256Versioning)) {
                return false;
            }
            Sha256Versioning other = (Sha256Versioning)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Sha256Versioning;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            return result;
        }
    }

    private static class TagVersioning
    implements Versioning {
        public static final String TAG_REGEX = "[\\w][\\w\\.\\-]{0,127}";
        private final String tag;

        TagVersioning(String tag) {
            this.tag = tag;
        }

        @Override
        public boolean isValid() {
            return this.tag.matches(TAG_REGEX);
        }

        @Override
        public String getSeparator() {
            return ":";
        }

        public String toString() {
            return this.tag;
        }

        public String getTag() {
            return this.tag;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TagVersioning)) {
                return false;
            }
            TagVersioning other = (TagVersioning)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tag = this.getTag();
            String other$tag = other.getTag();
            return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TagVersioning;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
            return result;
        }
    }

    private static interface Versioning {
        public boolean isValid();

        public String getSeparator();
    }
}

