/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.zeroturnaround.exec;

import org.slf4j.Logger;
import org.testcontainers.shaded.org.zeroturnaround.exec.MessageLogger;
import org.testcontainers.shaded.org.zeroturnaround.exec.stream.slf4j.Level;

public class MessageLoggers {
    public static final MessageLogger NOP = new MessageLogger(){

        public void message(Logger log, String format, Object ... arguments) {
        }
    };
    public static final MessageLogger TRACE = new MessageLogger(){

        public void message(Logger log, String format, Object ... arguments) {
            log.trace(format, arguments);
        }
    };
    public static final MessageLogger DEBUG = new MessageLogger(){

        public void message(Logger log, String format, Object ... arguments) {
            log.debug(format, arguments);
        }
    };
    public static final MessageLogger INFO = new MessageLogger(){

        public void message(Logger log, String format, Object ... arguments) {
            log.info(format, arguments);
        }
    };

    public static final MessageLogger get(Level level) {
        switch (level) {
            case TRACE: {
                return TRACE;
            }
            case DEBUG: {
                return DEBUG;
            }
            case INFO: {
                return INFO;
            }
        }
        throw new IllegalArgumentException("Invalid level " + (Object)((Object)level));
    }

    private MessageLoggers() {
    }
}

