/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.org.scalasbt.ipcsocket;

import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.testcontainers.shaded.org.scalasbt.ipcsocket.Win32NamedPipeLibrary;
import org.testcontainers.shaded.org.scalasbt.ipcsocket.Win32NamedPipeSocket;

public class Win32NamedPipeServerSocket
extends ServerSocket {
    private static final Win32NamedPipeLibrary API = Win32NamedPipeLibrary.INSTANCE;
    private static final String WIN32_PIPE_PREFIX = "\\\\.\\pipe\\";
    private static final int BUFFER_SIZE = 65535;
    private final LinkedBlockingQueue<WinNT.HANDLE> openHandles = new LinkedBlockingQueue();
    private final LinkedBlockingQueue<WinNT.HANDLE> connectedHandles = new LinkedBlockingQueue();
    private final Win32NamedPipeSocket.CloseCallback closeCallback = hANDLE -> {
        if (this.connectedHandles.remove(hANDLE)) {
            this.closeConnectedPipe(hANDLE, false);
        }
        if (this.openHandles.remove(hANDLE)) {
            this.closeOpenPipe(hANDLE);
        }
    };
    private final String path;
    private final int maxInstances;
    private final WinNT.HANDLE lockHandle;
    private final boolean requireStrictLength;

    public Win32NamedPipeServerSocket(String string) throws IOException {
        this(255, string);
    }

    public Win32NamedPipeServerSocket(String string, boolean bl) throws IOException {
        this(255, string, bl);
    }

    public Win32NamedPipeServerSocket(int n, String string) throws IOException {
        this(n, string, false);
    }

    public Win32NamedPipeServerSocket(int n, String string, boolean bl) throws IOException {
        this.maxInstances = n;
        this.requireStrictLength = bl;
        this.path = !string.startsWith(WIN32_PIPE_PREFIX) ? WIN32_PIPE_PREFIX + string : string;
        String string2 = this.path + "_lock";
        this.lockHandle = API.CreateNamedPipe(string2, 524291, 0, 1, 65535, 65535, 0, null);
        if (this.lockHandle == Win32NamedPipeLibrary.INVALID_HANDLE_VALUE) {
            throw new IOException(String.format("Could not create lock for %s, error %d", string2, API.GetLastError()));
        }
        if (!API.DisconnectNamedPipe(this.lockHandle)) {
            throw new IOException(String.format("Could not disconnect lock %d", API.GetLastError()));
        }
    }

    @Override
    public void bind(SocketAddress socketAddress) throws IOException {
        throw new IOException("Win32 named pipes do not support bind(), pass path to constructor");
    }

    @Override
    public Socket accept() throws IOException {
        WinNT.HANDLE hANDLE = API.CreateNamedPipe(this.path, 0x40000003, 0, this.maxInstances, 65535, 65535, 0, null);
        if (hANDLE == Win32NamedPipeLibrary.INVALID_HANDLE_VALUE) {
            throw new IOException(String.format("Could not create named pipe, error %d", API.GetLastError()));
        }
        this.openHandles.add(hANDLE);
        WinNT.HANDLE hANDLE2 = API.CreateEvent(null, true, false, null);
        WinBase.OVERLAPPED oVERLAPPED = new WinBase.OVERLAPPED();
        oVERLAPPED.hEvent = hANDLE2;
        oVERLAPPED.write();
        boolean bl = API.ConnectNamedPipe(hANDLE, oVERLAPPED.getPointer());
        if (bl) {
            this.openHandles.remove(hANDLE);
            this.connectedHandles.add(hANDLE);
            return new Win32NamedPipeSocket(hANDLE, this.closeCallback, this.requireStrictLength);
        }
        int n = API.GetLastError();
        if (n == 535) {
            this.openHandles.remove(hANDLE);
            this.connectedHandles.add(hANDLE);
            return new Win32NamedPipeSocket(hANDLE, this.closeCallback, this.requireStrictLength);
        }
        if (n == 232) {
            return new Win32NamedPipeSocket(hANDLE, this.closeCallback, this.requireStrictLength);
        }
        if (n == 997) {
            if (!API.GetOverlappedResult(hANDLE, oVERLAPPED.getPointer(), new IntByReference(), true)) {
                this.openHandles.remove(hANDLE);
                this.closeOpenPipe(hANDLE);
                throw new IOException("GetOverlappedResult() failed for connect operation: " + API.GetLastError());
            }
            this.openHandles.remove(hANDLE);
            this.connectedHandles.add(hANDLE);
            return new Win32NamedPipeSocket(hANDLE, this.closeCallback, this.requireStrictLength);
        }
        throw new IOException("ConnectNamedPipe() failed with: " + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            Object object2;
            ArrayList arrayList = new ArrayList();
            this.openHandles.drainTo(arrayList);
            for (Object object2 : arrayList) {
                this.closeOpenPipe((WinNT.HANDLE)object2);
            }
            ArrayList arrayList2 = new ArrayList();
            this.connectedHandles.drainTo(arrayList2);
            object2 = arrayList2.iterator();
            while (object2.hasNext()) {
                WinNT.HANDLE hANDLE = (WinNT.HANDLE)object2.next();
                this.closeConnectedPipe(hANDLE, true);
            }
        }
        finally {
            API.CloseHandle(this.lockHandle);
        }
    }

    private void closeOpenPipe(WinNT.HANDLE hANDLE) throws IOException {
        API.CancelIoEx(hANDLE, null);
        API.CloseHandle(hANDLE);
    }

    private void closeConnectedPipe(WinNT.HANDLE hANDLE, boolean bl) throws IOException {
        if (!bl) {
            API.WaitForSingleObject(hANDLE, 10000);
        }
        API.DisconnectNamedPipe(hANDLE);
        API.CloseHandle(hANDLE);
    }
}

