/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.images;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.ListImagesCmd;
import com.github.dockerjava.api.exception.DockerClientException;
import com.github.dockerjava.api.model.Image;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.ContainerFetchException;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.DockerLoggerFactory;
import org.testcontainers.utility.LazyFuture;

public class RemoteDockerImage
extends LazyFuture<String> {
    public static final Set<DockerImageName> AVAILABLE_IMAGE_NAME_CACHE = new HashSet<DockerImageName>();
    private DockerImageName imageName;

    public RemoteDockerImage(String dockerImageName) {
        this.imageName = new DockerImageName(dockerImageName);
    }

    public RemoteDockerImage(@NonNull String repository, @NonNull String tag) {
        if (repository == null) {
            throw new NullPointerException("repository is marked @NonNull but is null");
        }
        if (tag == null) {
            throw new NullPointerException("tag is marked @NonNull but is null");
        }
        this.imageName = new DockerImageName(repository, tag);
    }

    @Override
    protected final String resolve() {
        Logger logger = DockerLoggerFactory.getLogger(this.imageName.toString());
        DockerClient dockerClient = DockerClientFactory.instance().client();
        try {
            int attempts = 0;
            Exception lastException = null;
            while (true) {
                if (AVAILABLE_IMAGE_NAME_CACHE.contains(this.imageName)) {
                    logger.trace("{} is already in image name cache", (Object)this.imageName);
                    break;
                }
                ListImagesCmd listImagesCmd = dockerClient.listImagesCmd();
                if (Boolean.parseBoolean(System.getProperty("useFilter"))) {
                    listImagesCmd = listImagesCmd.withImageNameFilter(this.imageName.toString());
                }
                List updatedImages = (List)listImagesCmd.exec();
                updatedImages.stream().map(Image::getRepoTags).filter(Objects::nonNull).flatMap(Stream::of).map(DockerImageName::new).collect(Collectors.toCollection(() -> AVAILABLE_IMAGE_NAME_CACHE));
                if (AVAILABLE_IMAGE_NAME_CACHE.contains(this.imageName)) {
                    logger.trace("{} is in image name cache following listing of images", (Object)this.imageName);
                    break;
                }
                if (attempts == 0) {
                    logger.info("Pulling docker image: {}. Please be patient; this may take some time but only needs to be done once.", (Object)this.imageName);
                }
                if (attempts++ >= 3) {
                    logger.error("Retry limit reached while trying to pull image: {}. Please check output of `docker pull {}`", (Object)this.imageName, (Object)this.imageName);
                    throw new ContainerFetchException("Retry limit reached while trying to pull image: " + this.imageName, lastException);
                }
                try {
                    PullImageResultCallback callback = new PullImageResultCallback();
                    dockerClient.pullImageCmd(this.imageName.getUnversionedPart()).withTag(this.imageName.getVersionPart()).exec(callback);
                    callback.awaitCompletion();
                    AVAILABLE_IMAGE_NAME_CACHE.add(this.imageName);
                }
                catch (Exception e) {
                    lastException = e;
                    continue;
                }
                break;
            }
            return this.imageName.toString();
        }
        catch (DockerClientException e) {
            throw new ContainerFetchException("Failed to get Docker client for " + this.imageName, e);
        }
    }

    public String toString() {
        return "RemoteDockerImage(imageName=" + this.imageName + ")";
    }
}

