/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient.transport.okhttp;

import com.github.dockerjava.api.command.PingCmd;
import com.github.dockerjava.core.AbstractDockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.SSLConfig;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.PingCmdExec;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.transport.okhttp.NamedPipeSocketFactory;
import org.testcontainers.dockerclient.transport.okhttp.OkHttpWebTarget;
import org.testcontainers.dockerclient.transport.okhttp.UnixSocketFactory;
import org.testcontainers.shaded.com.google.common.collect.ImmutableList;
import org.testcontainers.shaded.com.google.common.collect.MultimapBuilder;
import org.testcontainers.shaded.com.google.common.collect.SetMultimap;
import org.testcontainers.shaded.okhttp3.ConnectionPool;
import org.testcontainers.shaded.okhttp3.Dns;
import org.testcontainers.shaded.okhttp3.HttpUrl;
import org.testcontainers.shaded.okhttp3.OkHttpClient;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;

public class OkHttpDockerCmdExecFactory
extends AbstractDockerCmdExecFactory {
    private static final Logger log = LoggerFactory.getLogger(OkHttpDockerCmdExecFactory.class);
    private static final String SOCKET_SUFFIX = ".socket";
    private OkHttpClient okHttpClient;
    private HttpUrl baseUrl;

    @Override
    public void init(DockerClientConfig dockerClientConfig) {
        HttpUrl.Builder baseUrlBuilder;
        SSLContext sslContext;
        super.init(dockerClientConfig);
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().readTimeout(0L, TimeUnit.SECONDS).retryOnConnectionFailure(true);
        URI dockerHost = dockerClientConfig.getDockerHost();
        switch (dockerHost.getScheme()) {
            case "unix": 
            case "npipe": {
                String socketPath = dockerHost.getPath();
                if ("unix".equals(dockerHost.getScheme())) {
                    clientBuilder.socketFactory(new UnixSocketFactory(socketPath));
                } else {
                    clientBuilder.socketFactory(new NamedPipeSocketFactory(socketPath));
                }
                clientBuilder.connectionPool(new ConnectionPool(0, 1L, TimeUnit.SECONDS)).dns(hostname -> {
                    if (hostname.endsWith(SOCKET_SUFFIX)) {
                        return Collections.singletonList(InetAddress.getByAddress(hostname, new byte[]{0, 0, 0, 0}));
                    }
                    return Dns.SYSTEM.lookup(hostname);
                });
            }
        }
        SSLConfig sslConfig = dockerClientConfig.getSSLConfig();
        if (sslConfig != null && (sslContext = sslConfig.getSSLContext()) != null) {
            clientBuilder.sslSocketFactory(sslContext.getSocketFactory(), new TrustAllX509TrustManager());
        }
        this.okHttpClient = clientBuilder.build();
        switch (dockerHost.getScheme()) {
            case "unix": 
            case "npipe": {
                baseUrlBuilder = new HttpUrl.Builder().scheme("http").host("docker.socket");
                break;
            }
            case "tcp": {
                baseUrlBuilder = new HttpUrl.Builder().scheme(sslConfig != null && sslConfig.getSSLContext() != null ? "https" : "http").host(dockerHost.getHost()).port(dockerHost.getPort());
                break;
            }
            default: {
                baseUrlBuilder = HttpUrl.get(dockerHost.toString()).newBuilder();
            }
        }
        this.baseUrl = baseUrlBuilder.build();
    }

    @Override
    protected WebTarget getBaseResource() {
        return new OkHttpWebTarget(this.okHttpClient, this.baseUrl, ImmutableList.of(), (SetMultimap<String, String>)MultimapBuilder.hashKeys().hashSetValues().build());
    }

    @Override
    public PingCmd.Exec createPingCmdExec() {
        return new PingCmdExec(this.getBaseResource(), this.getDockerClientConfig()){

            @Override
            protected Void execute(PingCmd command) {
                WebTarget webResource = this.getBaseResource().path("/_ping");
                IOUtils.closeQuietly(webResource.request().get());
                return null;
            }
        };
    }

    @Override
    public void close() throws IOException {
    }

    private static class TrustAllX509TrustManager
    implements X509TrustManager {
        private TrustAllX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

