/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient.transport.okhttp;

import com.sun.jna.platform.win32.Kernel32;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import org.rnorth.ducttape.unreliables.Unreliables;

public final class NamedPipeSocketFactory
extends SocketFactory {
    private final String socketFileName;

    @Override
    public Socket createSocket() {
        return new Socket(){
            RandomAccessFile file;
            InputStream is;
            OutputStream os;

            @Override
            public void close() throws IOException {
                if (this.file != null) {
                    this.file.close();
                    this.file = null;
                }
            }

            @Override
            public void connect(SocketAddress endpoint) {
                this.connect(endpoint, 0);
            }

            @Override
            public void connect(SocketAddress endpoint, int timeout) {
                this.file = (RandomAccessFile)Unreliables.retryUntilSuccess((int)Math.max(timeout, 10000), (TimeUnit)TimeUnit.MILLISECONDS, () -> {
                    try {
                        return new RandomAccessFile(NamedPipeSocketFactory.this.socketFileName, "rw");
                    }
                    catch (FileNotFoundException e) {
                        Kernel32.INSTANCE.WaitNamedPipe(NamedPipeSocketFactory.this.socketFileName, 100);
                        throw e;
                    }
                });
                this.is = new InputStream(){

                    @Override
                    public int read(byte[] bytes, int off, int len) throws IOException {
                        return file.read(bytes, off, len);
                    }

                    @Override
                    public int read() throws IOException {
                        return file.read();
                    }

                    @Override
                    public int read(byte[] bytes) throws IOException {
                        return file.read(bytes);
                    }
                };
                this.os = new OutputStream(){

                    @Override
                    public void write(byte[] bytes, int off, int len) throws IOException {
                        file.write(bytes, off, len);
                    }

                    @Override
                    public void write(int value) throws IOException {
                        file.write(value);
                    }

                    @Override
                    public void write(byte[] bytes) throws IOException {
                        file.write(bytes);
                    }
                };
            }

            @Override
            public InputStream getInputStream() {
                return this.is;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.os;
            }
        };
    }

    @Override
    public Socket createSocket(String s, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) {
        throw new UnsupportedOperationException();
    }

    public NamedPipeSocketFactory(String socketFileName) {
        this.socketFileName = socketFileName;
    }

    public String getSocketFileName() {
        return this.socketFileName;
    }

    public String toString() {
        return "NamedPipeSocketFactory(socketFileName=" + this.getSocketFileName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NamedPipeSocketFactory)) {
            return false;
        }
        NamedPipeSocketFactory other = (NamedPipeSocketFactory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$socketFileName = this.getSocketFileName();
        String other$socketFileName = other.getSocketFileName();
        return !(this$socketFileName == null ? other$socketFileName != null : !this$socketFileName.equals(other$socketFileName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NamedPipeSocketFactory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $socketFileName = this.getSocketFileName();
        result = result * 59 + ($socketFileName == null ? 43 : $socketFileName.hashCode());
        return result;
    }
}

