/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.dockerclient.InvalidConfigurationException;
import org.testcontainers.shaded.org.apache.commons.lang.SystemUtils;
import org.testcontainers.utility.ComparableVersion;

public class UnixSocketClientProviderStrategy
extends DockerClientProviderStrategy {
    private static final Logger log = LoggerFactory.getLogger(UnixSocketClientProviderStrategy.class);
    protected static final String DOCKER_SOCK_PATH = "/var/run/docker.sock";
    private static final String SOCKET_LOCATION = "unix:///var/run/docker.sock";
    private static final int SOCKET_FILE_MODE_MASK = 49152;
    private static final String PING_TIMEOUT_DEFAULT = "10";
    private static final String PING_TIMEOUT_PROPERTY_NAME = "testcontainers.unixsocketprovider.timeout";
    public static final int PRIORITY = 80;

    @Override
    protected boolean isApplicable() {
        boolean nettyDoesSupportMacUnixSockets = SystemUtils.IS_OS_MAC_OSX && ComparableVersion.OS_VERSION.isGreaterThanOrEqualTo("10.12");
        return SystemUtils.IS_OS_LINUX || nettyDoesSupportMacUnixSockets;
    }

    @Override
    public void test() throws InvalidConfigurationException {
        try {
            this.config = this.tryConfiguration(SOCKET_LOCATION);
            log.info("Accessing docker with local Unix socket");
        }
        catch (Exception | UnsatisfiedLinkError e) {
            throw new InvalidConfigurationException("ping failed", e);
        }
    }

    @NotNull
    protected DockerClientConfig tryConfiguration(String dockerHost) {
        Integer mode;
        Path dockerSocketFile = Paths.get(DOCKER_SOCK_PATH, new String[0]);
        try {
            mode = (Integer)Files.getAttribute(dockerSocketFile, "unix:mode", new LinkOption[0]);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Could not find unix domain socket", e);
        }
        if ((mode & 0xC000) != 49152) {
            throw new InvalidConfigurationException("Found docker unix domain socket but file mode was not as expected (expected: srwxr-xr-x). This problem is possibly due to occurrence of this issue in the past: https://github.com/docker/docker/issues/13121");
        }
        this.config = DefaultDockerClientConfig.createDefaultConfigBuilder().withDockerHost(dockerHost).withDockerTlsVerify(false).build();
        this.client = this.getClientForConfig(this.config);
        int timeout = Integer.parseInt(System.getProperty(PING_TIMEOUT_PROPERTY_NAME, PING_TIMEOUT_DEFAULT));
        this.ping(this.client, timeout);
        return this.config;
    }

    @Override
    public String getDescription() {
        return "local Unix socket (unix:///var/run/docker.sock)";
    }

    @Override
    protected int getPriority() {
        return 80;
    }
}

