/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.dockerclient;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.core.DockerClientConfig;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.rnorth.ducttape.TimeoutException;
import org.rnorth.ducttape.ratelimits.RateLimiter;
import org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import org.rnorth.ducttape.unreliables.Unreliables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.AuditLoggingDockerClient;
import org.testcontainers.dockerclient.DockerClientConfigUtils;
import org.testcontainers.dockerclient.InvalidConfigurationException;
import org.testcontainers.dockerclient.auth.AuthDelegatingDockerClientConfig;
import org.testcontainers.dockerclient.transport.okhttp.OkHttpDockerCmdExecFactory;
import org.testcontainers.shaded.com.google.common.base.Throwables;
import org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import org.testcontainers.utility.TestcontainersConfiguration;

public abstract class DockerClientProviderStrategy {
    protected DockerClient client;
    protected DockerClientConfig config;
    private static final RateLimiter PING_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(2, TimeUnit.SECONDS).withConstantThroughput().build();
    private static final AtomicBoolean FAIL_FAST_ALWAYS = new AtomicBoolean(false);
    protected static final Logger LOGGER = LoggerFactory.getLogger(DockerClientProviderStrategy.class);

    public abstract void test() throws InvalidConfigurationException;

    public abstract String getDescription();

    protected boolean isApplicable() {
        return true;
    }

    protected boolean isPersistable() {
        return true;
    }

    protected int getPriority() {
        return 0;
    }

    public static DockerClientProviderStrategy getFirstValidStrategy(List<DockerClientProviderStrategy> strategies) {
        if (FAIL_FAST_ALWAYS.get()) {
            throw new IllegalStateException("Previous attempts to find a Docker environment failed. Will not retry. Please see logs and check configuration");
        }
        ArrayList configurationFailures = new ArrayList();
        return (DockerClientProviderStrategy)Stream.concat(Stream.of(TestcontainersConfiguration.getInstance().getDockerClientStrategyClassName()).filter(Objects::nonNull).flatMap(it -> {
            try {
                Class<?> strategyClass = Thread.currentThread().getContextClassLoader().loadClass((String)it);
                return Stream.of(strategyClass.newInstance());
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("Can't instantiate a strategy from {} (ClassNotFoundException). This probably means that cached configuration refers to a client provider class that is not available in this version of Testcontainers. Other strategies will be tried instead.", it);
                return Stream.empty();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.warn("Can't instantiate a strategy from {}", it, (Object)e);
                return Stream.empty();
            }
        }).filter(DockerClientProviderStrategy::isPersistable).peek(strategy -> LOGGER.info("Loaded {} from ~/.testcontainers.properties, will try it first", (Object)strategy.getClass().getName())), strategies.stream().filter(DockerClientProviderStrategy::isApplicable).sorted(Comparator.comparing(DockerClientProviderStrategy::getPriority).reversed())).flatMap(strategy -> {
            try {
                strategy.test();
                LOGGER.info("Found Docker environment with {}", (Object)strategy.getDescription());
                if (strategy.isPersistable()) {
                    TestcontainersConfiguration.getInstance().updateGlobalConfig("docker.client.strategy", strategy.getClass().getName());
                }
                return Stream.of(strategy);
            }
            catch (Exception | ExceptionInInitializerError | NoClassDefFoundError e) {
                @Nullable String throwableMessage = e.getMessage();
                Throwable rootCause = Throwables.getRootCause(e);
                @Nullable String rootCauseMessage = rootCause.getMessage();
                String failureDescription = throwableMessage != null && throwableMessage.equals(rootCauseMessage) ? String.format("%s: failed with exception %s (%s)", strategy.getClass().getSimpleName(), e.getClass().getSimpleName(), throwableMessage) : String.format("%s: failed with exception %s (%s). Root cause %s (%s)", strategy.getClass().getSimpleName(), e.getClass().getSimpleName(), throwableMessage, rootCause.getClass().getSimpleName(), rootCauseMessage);
                configurationFailures.add(failureDescription);
                LOGGER.debug(failureDescription);
                return Stream.empty();
            }
        }).findAny().orElseThrow(() -> {
            LOGGER.error("Could not find a valid Docker environment. Please check configuration. Attempted configurations were:");
            for (String failureMessage : configurationFailures) {
                LOGGER.error("    " + failureMessage);
            }
            LOGGER.error("As no valid configuration was found, execution cannot continue");
            FAIL_FAST_ALWAYS.set(true);
            return new IllegalStateException("Could not find a valid Docker environment. Please see logs and check configuration");
        });
    }

    public DockerClient getClient() {
        return new AuditLoggingDockerClient(this.client);
    }

    protected DockerClient getClientForConfig(DockerClientConfig config) {
        DockerClientBuilder clientBuilder = DockerClientBuilder.getInstance(new AuthDelegatingDockerClientConfig(config));
        String transportType = TestcontainersConfiguration.getInstance().getTransportType();
        if (!"okhttp".equals(transportType)) {
            throw new IllegalArgumentException("Unknown transport type: " + transportType);
        }
        clientBuilder.withDockerCmdExecFactory(new OkHttpDockerCmdExecFactory());
        LOGGER.info("Will use '{}' transport", (Object)transportType);
        return clientBuilder.build();
    }

    protected void ping(DockerClient client, int timeoutInSeconds) {
        try {
            Unreliables.retryUntilSuccess((int)timeoutInSeconds, (TimeUnit)TimeUnit.SECONDS, () -> (Boolean)PING_RATE_LIMITER.getWhenReady(() -> {
                LOGGER.debug("Pinging docker daemon...");
                client.pingCmd().exec();
                return true;
            }));
        }
        catch (TimeoutException e) {
            IOUtils.closeQuietly((Closeable)client);
            throw e;
        }
    }

    public String getDockerHostIpAddress() {
        return DockerClientConfigUtils.getDockerHostIpAddress(this.config);
    }
}

