/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.internal;

import java.util.Set;
import java.util.concurrent.Callable;
import org.testcontainers.containers.ExecInContainerPattern;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;

public class InternalCommandPortListeningCheck
implements Callable<Boolean> {
    private final WaitStrategyTarget waitStrategyTarget;
    private final Set<Integer> internalPorts;

    @Override
    public Boolean call() {
        for (Integer internalPort : this.internalPorts) {
            this.tryPort(internalPort);
        }
        return true;
    }

    private void tryPort(Integer internalPort) {
        String[][] commands;
        for (String[] command : commands = new String[][]{{"/bin/sh", "-c", String.format("cat /proc/net/tcp{,6} | awk '{print $2}' | grep -i :%x", internalPort)}, {"/bin/sh", "-c", String.format("nc -vz -w 1 localhost %d", internalPort)}, {"/bin/bash", "-c", String.format("</dev/tcp/localhost/%d", internalPort)}}) {
            try {
                if (ExecInContainerPattern.execInContainer(this.waitStrategyTarget.getContainerInfo(), command).getExitCode() != 0) continue;
                return;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException("Socket not listening yet: " + internalPort);
    }

    public InternalCommandPortListeningCheck(WaitStrategyTarget waitStrategyTarget, Set<Integer> internalPorts) {
        this.waitStrategyTarget = waitStrategyTarget;
        this.internalPorts = internalPorts;
    }
}

