/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.wait.internal;

import java.io.IOException;
import java.net.Socket;
import java.util.Set;
import java.util.concurrent.Callable;
import org.testcontainers.containers.ContainerState;

public class ExternalPortListeningCheck
implements Callable<Boolean> {
    private final ContainerState containerState;
    private final Set<Integer> externalLivenessCheckPorts;

    @Override
    public Boolean call() {
        String address = this.containerState.getContainerIpAddress();
        for (Integer externalPort : this.externalLivenessCheckPorts) {
            try {
                new Socket(address, (int)externalPort).close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Socket not listening yet: " + externalPort);
            }
        }
        return true;
    }

    public ExternalPortListeningCheck(ContainerState containerState, Set<Integer> externalLivenessCheckPorts) {
        this.containerState = containerState;
        this.externalLivenessCheckPorts = externalLivenessCheckPorts;
    }
}

