/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.shaded.com.google.common.base.Charsets;

public class ToStringConsumer
extends BaseConsumer<ToStringConsumer> {
    private static final byte[] NEW_LINE = "\n".getBytes();
    private boolean firstLine = true;
    private ByteArrayOutputStream stringBuffer = new ByteArrayOutputStream();

    @Override
    public void accept(OutputFrame outputFrame) {
        try {
            if (outputFrame.getBytes() != null) {
                if (!this.firstLine) {
                    this.stringBuffer.write(NEW_LINE);
                }
                this.stringBuffer.write(outputFrame.getBytes());
                this.stringBuffer.flush();
                this.firstLine = false;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toUtf8String() {
        byte[] bytes = this.stringBuffer.toByteArray();
        return new String(bytes, Charsets.UTF_8);
    }

    public String toString(Charset charset) {
        byte[] bytes = this.stringBuffer.toByteArray();
        return new String(bytes, charset);
    }
}

