/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.TestcontainersConfiguration;

public class SocatContainer
extends GenericContainer<SocatContainer> {
    private final Map<Integer, String> targets = new HashMap<Integer, String>();

    public SocatContainer() {
        super(TestcontainersConfiguration.getInstance().getSocatContainerImage());
        this.withCreateContainerCmdModifier(it -> it.withEntrypoint("/bin/sh"));
        this.withCreateContainerCmdModifier(it -> it.withName("testcontainers-socat-" + Base58.randomString(8)));
    }

    public SocatContainer withTarget(int exposedPort, String host) {
        return this.withTarget(exposedPort, host, exposedPort);
    }

    public SocatContainer withTarget(int exposedPort, String host, int internalPort) {
        this.addExposedPort(exposedPort);
        this.targets.put(exposedPort, String.format("%s:%s", host, internalPort));
        return (SocatContainer)this.self();
    }

    @Override
    protected void configure() {
        this.withCommand(new String[]{"-c", this.targets.entrySet().stream().map(entry -> "socat TCP-LISTEN:" + entry.getKey() + ",fork,reuseaddr TCP:" + (String)entry.getValue()).collect(Collectors.joining(" & "))});
    }
}

