/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.ExecCreateCmdResponse;
import com.github.dockerjava.api.exception.InternalServerErrorException;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.AccessMode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Info;
import com.github.dockerjava.api.model.Version;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.command.ExecStartResultCallback;
import com.github.dockerjava.core.command.PullImageResultCallback;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.rnorth.visibleassertions.VisibleAssertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.dockerclient.DockerClientProviderStrategy;
import org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;
import org.testcontainers.utility.ComparableVersion;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.ResourceReaper;
import org.testcontainers.utility.TestcontainersConfiguration;

public class DockerClientFactory {
    private static final Logger log = LoggerFactory.getLogger(DockerClientFactory.class);
    private final Object $lock = new Object[0];
    public static final ThreadGroup TESTCONTAINERS_THREAD_GROUP = new ThreadGroup("testcontainers");
    public static final String TESTCONTAINERS_LABEL = DockerClientFactory.class.getPackage().getName();
    public static final String TESTCONTAINERS_SESSION_ID_LABEL = TESTCONTAINERS_LABEL + ".sessionId";
    public static final String SESSION_ID = UUID.randomUUID().toString();
    public static final Map<String, String> DEFAULT_LABELS = ImmutableMap.of(TESTCONTAINERS_LABEL, "true", TESTCONTAINERS_SESSION_ID_LABEL, SESSION_ID);
    private static final String TINY_IMAGE = TestcontainersConfiguration.getInstance().getTinyImage();
    private static DockerClientFactory instance;
    private DockerClientProviderStrategy strategy;
    private boolean initialized = false;
    private String activeApiVersion;
    private String activeExecutionDriver;
    private final AtomicReference<Object> fileMountingSupported = new AtomicReference();

    private DockerClientFactory() {
    }

    public static synchronized DockerClientFactory instance() {
        if (instance == null) {
            instance = new DockerClientFactory();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DockerClient client() {
        Object object = this.$lock;
        synchronized (object) {
            if (this.strategy != null) {
                return this.strategy.getClient();
            }
            ArrayList<DockerClientProviderStrategy> configurationStrategies = new ArrayList<DockerClientProviderStrategy>();
            ServiceLoader.load(DockerClientProviderStrategy.class).forEach(cs -> configurationStrategies.add((DockerClientProviderStrategy)cs));
            this.strategy = DockerClientProviderStrategy.getFirstValidStrategy(configurationStrategies);
            String hostIpAddress = this.strategy.getDockerHostIpAddress();
            log.info("Docker host IP address is {}", (Object)hostIpAddress);
            DockerClient client = this.strategy.getClient();
            if (!this.initialized) {
                boolean checksEnabled;
                boolean useRyuk;
                Info dockerInfo = (Info)client.infoCmd().exec();
                Version version = (Version)client.versionCmd().exec();
                this.activeApiVersion = version.getApiVersion();
                this.activeExecutionDriver = dockerInfo.getExecutionDriver();
                log.info("Connected to docker: \n  Server Version: " + dockerInfo.getServerVersion() + "\n  API Version: " + this.activeApiVersion + "\n  Operating System: " + dockerInfo.getOperatingSystem() + "\n  Total Memory: " + dockerInfo.getMemTotal() / 0x100000L + " MB");
                String ryukContainerId = null;
                boolean bl = useRyuk = !Boolean.parseBoolean(System.getenv("TESTCONTAINERS_RYUK_DISABLED"));
                if (useRyuk) {
                    ryukContainerId = ResourceReaper.start(hostIpAddress, client);
                    log.info("Ryuk started - will monitor and terminate Testcontainers containers on JVM exit");
                }
                boolean bl2 = checksEnabled = !TestcontainersConfiguration.getInstance().isDisableChecks();
                if (checksEnabled) {
                    VisibleAssertions.info((String)"Checking the system...");
                    this.checkDockerVersion(version.getVersion());
                    if (ryukContainerId != null) {
                        this.checkDiskSpace(client, ryukContainerId);
                    } else {
                        this.runInsideDocker(client, createContainerCmd -> {
                            createContainerCmd.withName("testcontainers-checks-" + SESSION_ID);
                            createContainerCmd.getHostConfig().withAutoRemove(true);
                            createContainerCmd.withCmd("tail", "-f", "/dev/null");
                        }, (__, containerId) -> {
                            this.checkDiskSpace(client, (String)containerId);
                            return "";
                        });
                    }
                }
                this.initialized = true;
            }
            return client;
        }
    }

    private void checkDockerVersion(String dockerVersion) {
        VisibleAssertions.assertThat((String)"Docker version", (Object)dockerVersion, (Matcher)new BaseMatcher<String>(){

            public boolean matches(Object o) {
                return new ComparableVersion(o.toString()).compareTo(new ComparableVersion("1.6.0")) >= 0;
            }

            public void describeTo(Description description) {
                description.appendText("should be at least 1.6.0");
            }
        });
    }

    private void checkDiskSpace(DockerClient dockerClient, String id) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            dockerClient.execStartCmd(((ExecCreateCmdResponse)dockerClient.execCreateCmd(id).withAttachStdout(true).withCmd("df", "-P").exec()).getId()).exec(new ExecStartResultCallback(outputStream, null)).awaitCompletion();
        }
        catch (Exception e) {
            log.debug("Can't exec disk checking command", (Throwable)e);
        }
        DiskSpaceUsage df = this.parseAvailableDiskSpace(outputStream.toString());
        VisibleAssertions.assertTrue((String)"Docker environment should have more than 2GB free disk space", (boolean)df.availableMB.map(it -> it >= 2048L).orElse(true));
    }

    private boolean checkMountableFile() {
        DockerClient dockerClient = this.client();
        MountableFile mountableFile = MountableFile.forClasspathResource(ResourceReaper.class.getName().replace(".", "/") + ".class");
        Volume volume = new Volume("/dummy");
        try {
            return this.runInsideDocker(createContainerCmd -> createContainerCmd.withBinds(new Bind(mountableFile.getResolvedPath(), volume, AccessMode.ro)), (__, containerId) -> {
                try (InputStream stream = dockerClient.copyArchiveFromContainerCmd((String)containerId, volume.getPath()).exec();){
                    stream.read();
                    Boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    return false;
                }
            });
        }
        catch (Exception e) {
            log.debug("Failure while checking for mountable file support", (Throwable)e);
            return false;
        }
    }

    public void checkAndPullImage(DockerClient client, String image) {
        List images = (List)client.listImagesCmd().withImageNameFilter(image).exec();
        if (images.isEmpty()) {
            client.pullImageCmd(image).exec(new PullImageResultCallback()).awaitSuccess();
        }
    }

    public String dockerHostIpAddress() {
        return this.strategy.getDockerHostIpAddress();
    }

    public <T> T runInsideDocker(Consumer<CreateContainerCmd> createContainerCmdConsumer, BiFunction<DockerClient, String, T> block) {
        if (this.strategy == null) {
            this.client();
        }
        return this.runInsideDocker(this.strategy.getClient(), createContainerCmdConsumer, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T runInsideDocker(DockerClient client, Consumer<CreateContainerCmd> createContainerCmdConsumer, BiFunction<DockerClient, String, T> block) {
        this.checkAndPullImage(client, TINY_IMAGE);
        CreateContainerCmd createContainerCmd = client.createContainerCmd(TINY_IMAGE).withLabels(DEFAULT_LABELS);
        createContainerCmdConsumer.accept(createContainerCmd);
        String id = createContainerCmd.exec().getId();
        try {
            client.startContainerCmd(id).exec();
            T t = block.apply(client, id);
            return t;
        }
        finally {
            try {
                client.removeContainerCmd(id).withRemoveVolumes(true).withForce(true).exec();
            }
            catch (InternalServerErrorException | NotFoundException ignored) {
                log.debug("", (Throwable)ignored);
            }
        }
    }

    @VisibleForTesting
    DiskSpaceUsage parseAvailableDiskSpace(String dfOutput) {
        String[] lines;
        DiskSpaceUsage df = new DiskSpaceUsage();
        for (String line : lines = dfOutput.split("\n")) {
            String[] fields = line.split("\\s+");
            if (fields.length <= 5 || !fields[5].equals("/")) continue;
            long availableKB = Long.valueOf(fields[3]);
            df.availableMB = Optional.of(availableKB / 1024L);
            df.usedPercent = Optional.of(Integer.valueOf(fields[4].replace("%", "")));
            break;
        }
        return df;
    }

    public String getActiveApiVersion() {
        if (!this.initialized) {
            this.client();
        }
        return this.activeApiVersion;
    }

    public String getActiveExecutionDriver() {
        if (!this.initialized) {
            this.client();
        }
        return this.activeExecutionDriver;
    }

    public boolean isUsing(Class<? extends DockerClientProviderStrategy> providerStrategyClass) {
        return providerStrategyClass.isAssignableFrom(this.strategy.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFileMountingSupported() {
        Object value = this.fileMountingSupported.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.fileMountingSupported;
            synchronized (atomicReference) {
                value = this.fileMountingSupported.get();
                if (value == null) {
                    boolean actualValue = this.checkMountableFile();
                    value = actualValue;
                    this.fileMountingSupported.set(value);
                }
            }
        }
        return (Boolean)value;
    }

    static {
        System.setProperty("org.testcontainers.shaded.io.netty.packagePrefix", "org.testcontainers.shaded.");
    }

    private static class NotEnoughDiskSpaceException
    extends RuntimeException {
        NotEnoughDiskSpaceException(String message) {
            super(message);
        }
    }

    @VisibleForTesting
    static class DiskSpaceUsage {
        Optional<Long> availableMB = Optional.empty();
        Optional<Integer> usedPercent = Optional.empty();

        DiskSpaceUsage() {
        }
    }
}

