/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.jaxrs;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.RemoteApiVersion;
import java.io.IOException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.org.apache.commons.codec.binary.Base64;

public abstract class AbstrDockerCmdExec {
    private final DockerClientConfig dockerClientConfig;
    private final WebTarget baseResource;

    public AbstrDockerCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(baseResource, "baseResource was not specified");
        Preconditions.checkNotNull(dockerClientConfig, "dockerClientConfig was not specified");
        this.baseResource = baseResource;
        this.dockerClientConfig = dockerClientConfig;
    }

    protected WebTarget getBaseResource() {
        return this.baseResource;
    }

    protected AuthConfigurations getBuildAuthConfigs() {
        return this.dockerClientConfig.getAuthConfigurations();
    }

    protected String registryAuth(AuthConfig authConfig) {
        try {
            return Base64.encodeBase64String(new ObjectMapper().writeValueAsString(authConfig).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Invocation.Builder resourceWithAuthConfig(AuthConfig authConfig, Invocation.Builder request) {
        request = request.header("X-Registry-Auth", (Object)this.registryAuth(authConfig));
        return request;
    }

    protected Invocation.Builder resourceWithOptionalAuthConfig(AuthConfig authConfig, Invocation.Builder request) {
        if (authConfig != null) {
            request = this.resourceWithAuthConfig(authConfig, request);
        }
        return request;
    }

    protected String registryConfigs(AuthConfigurations authConfigs) {
        try {
            String json;
            ObjectMapper objectMapper = new ObjectMapper();
            RemoteApiVersion apiVersion = this.dockerClientConfig.getApiVersion();
            if (apiVersion.equals(RemoteApiVersion.UNKNOWN_VERSION)) {
                ObjectNode rootNode = (ObjectNode)objectMapper.valueToTree(authConfigs.getConfigs());
                ObjectNode authNodes = (ObjectNode)objectMapper.valueToTree(authConfigs);
                rootNode.setAll(authNodes);
                json = rootNode.toString();
            } else {
                json = apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_19) ? objectMapper.writeValueAsString(authConfigs.getConfigs()) : objectMapper.writeValueAsString(authConfigs);
            }
            return Base64.encodeBase64String(json.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean bool(Boolean bool) {
        return bool != null && bool != false;
    }

    protected WebTarget booleanQueryParam(WebTarget webTarget, String name, Boolean value) {
        if (this.bool(value)) {
            webTarget = webTarget.queryParam(name, new Object[]{this.bool(value) + ""});
        }
        return webTarget;
    }
}

