/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.exec;

import com.github.dockerjava.api.model.AuthConfig;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.RemoteApiVersion;
import com.github.dockerjava.core.WebTarget;
import java.io.IOException;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.testcontainers.shaded.com.google.common.base.Preconditions;
import org.testcontainers.shaded.org.apache.commons.codec.binary.Base64;

public abstract class AbstrDockerCmdExec {
    private final DockerClientConfig dockerClientConfig;
    private final WebTarget baseResource;

    public AbstrDockerCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        Preconditions.checkNotNull(baseResource, "baseResource was not specified");
        Preconditions.checkNotNull(dockerClientConfig, "dockerClientConfig was not specified");
        this.baseResource = baseResource;
        this.dockerClientConfig = dockerClientConfig;
    }

    protected WebTarget getBaseResource() {
        return this.baseResource;
    }

    protected AuthConfigurations getBuildAuthConfigs() {
        return this.dockerClientConfig.getAuthConfigurations();
    }

    protected String registryAuth(AuthConfig authConfig) {
        try {
            return Base64.encodeBase64String(new ObjectMapper().writeValueAsString(authConfig).getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String registryConfigs(AuthConfigurations authConfigs) {
        try {
            String json;
            ObjectMapper objectMapper = new ObjectMapper();
            RemoteApiVersion apiVersion = this.dockerClientConfig.getApiVersion();
            if (apiVersion.equals(RemoteApiVersion.UNKNOWN_VERSION)) {
                ObjectNode rootNode = (ObjectNode)objectMapper.valueToTree(authConfigs.getConfigs());
                ObjectNode authNodes = (ObjectNode)objectMapper.valueToTree(authConfigs);
                rootNode.setAll(authNodes);
                json = rootNode.toString();
            } else {
                json = apiVersion.isGreaterOrEqual(RemoteApiVersion.VERSION_1_19) ? objectMapper.writeValueAsString(authConfigs.getConfigs()) : objectMapper.writeValueAsString(authConfigs);
            }
            return Base64.encodeBase64String(json.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected InvocationBuilder resourceWithAuthConfig(AuthConfig authConfig, InvocationBuilder request) {
        return request.header("X-Registry-Auth", this.registryAuth(authConfig));
    }

    protected InvocationBuilder resourceWithOptionalAuthConfig(AuthConfig authConfig, InvocationBuilder request) {
        if (authConfig != null) {
            request = this.resourceWithAuthConfig(authConfig, request);
        }
        return request;
    }

    protected boolean bool(Boolean bool) {
        return bool != null && bool != false;
    }

    protected WebTarget booleanQueryParam(WebTarget webTarget, String name, Boolean value) {
        if (this.bool(value)) {
            webTarget = webTarget.queryParam(name, this.bool(value) + "");
        }
        return webTarget;
    }
}

