/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.server.standard;

import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.util.PathTemplate;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpointFactory;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.jsr.handshake.JsrHybi07Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi08Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.server.ServerEndpointConfig;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.socket.server.HandshakeFailureException;
import org.springframework.web.socket.server.standard.AbstractStandardUpgradeStrategy;
import org.springframework.web.socket.server.standard.ServerEndpointRegistration;

public class UndertowRequestUpgradeStrategy
extends AbstractStandardUpgradeStrategy {
    private static final Constructor<ServletWebSocketHttpExchange> exchangeConstructor;
    private static final boolean exchangeConstructorWithPeerConnections;
    private static final Constructor<ConfiguredServerEndpoint> endpointConstructor;
    private static final boolean endpointConstructorWithEndpointFactory;
    private static final Method getBufferPoolMethod;
    private static final Method createChannelMethod;
    private static final String[] supportedVersions;
    private final Set<WebSocketChannel> peerConnections = exchangeConstructorWithPeerConnections ? Collections.newSetFromMap(new ConcurrentHashMap()) : null;

    @Override
    public String[] getSupportedVersions() {
        return supportedVersions;
    }

    @Override
    protected void upgradeInternal(ServerHttpRequest request, ServerHttpResponse response, String selectedProtocol, List<Extension> selectedExtensions, Endpoint endpoint) throws HandshakeFailureException {
        HttpServletRequest servletRequest = this.getHttpServletRequest(request);
        HttpServletResponse servletResponse = this.getHttpServletResponse(response);
        final ServletWebSocketHttpExchange exchange = this.createHttpExchange(servletRequest, servletResponse);
        exchange.putAttachment(HandshakeUtil.PATH_PARAMS, Collections.emptyMap());
        ServerWebSocketContainer wsContainer = (ServerWebSocketContainer)this.getContainer(servletRequest);
        final EndpointSessionHandler endpointSessionHandler = new EndpointSessionHandler(wsContainer);
        ConfiguredServerEndpoint configuredServerEndpoint = this.createConfiguredServerEndpoint(selectedProtocol, selectedExtensions, endpoint, servletRequest);
        final Handshake handshake = this.getHandshakeToUse(exchange, configuredServerEndpoint);
        HttpUpgradeListener upgradeListener = (HttpUpgradeListener)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpUpgradeListener.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("handleUpgrade".equals(method.getName())) {
                    Object connection = args[0];
                    Object bufferPool = ReflectionUtils.invokeMethod((Method)getBufferPoolMethod, (Object)exchange);
                    WebSocketChannel channel = (WebSocketChannel)ReflectionUtils.invokeMethod((Method)createChannelMethod, (Object)handshake, (Object[])new Object[]{exchange, connection, bufferPool});
                    if (UndertowRequestUpgradeStrategy.this.peerConnections != null) {
                        UndertowRequestUpgradeStrategy.this.peerConnections.add(channel);
                    }
                    endpointSessionHandler.onConnect((WebSocketHttpExchange)exchange, channel);
                    return null;
                }
                return ReflectionUtils.invokeMethod((Method)method, (Object)this, (Object[])args);
            }
        });
        exchange.upgradeChannel(upgradeListener);
        handshake.handshake((WebSocketHttpExchange)exchange);
    }

    private ServletWebSocketHttpExchange createHttpExchange(HttpServletRequest request, HttpServletResponse response) {
        try {
            return this.peerConnections != null ? exchangeConstructor.newInstance(request, response, this.peerConnections) : exchangeConstructor.newInstance(request, response);
        }
        catch (Exception ex) {
            throw new HandshakeFailureException("Failed to instantiate ServletWebSocketHttpExchange", ex);
        }
    }

    private Handshake getHandshakeToUse(ServletWebSocketHttpExchange exchange, ConfiguredServerEndpoint endpoint) {
        JsrHybi13Handshake handshake = new JsrHybi13Handshake(endpoint);
        if (handshake.matches((WebSocketHttpExchange)exchange)) {
            return handshake;
        }
        handshake = new JsrHybi08Handshake(endpoint);
        if (handshake.matches((WebSocketHttpExchange)exchange)) {
            return handshake;
        }
        handshake = new JsrHybi07Handshake(endpoint);
        if (handshake.matches((WebSocketHttpExchange)exchange)) {
            return handshake;
        }
        throw new HandshakeFailureException("No matching Undertow Handshake found: " + exchange.getRequestHeaders());
    }

    private ConfiguredServerEndpoint createConfiguredServerEndpoint(String selectedProtocol, List<Extension> selectedExtensions, Endpoint endpoint, HttpServletRequest servletRequest) {
        String path = servletRequest.getRequestURI();
        ServerEndpointRegistration endpointRegistration = new ServerEndpointRegistration(path, endpoint);
        endpointRegistration.setSubprotocols(Arrays.asList(selectedProtocol));
        endpointRegistration.setExtensions(selectedExtensions);
        EncodingFactory encodingFactory = new EncodingFactory(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
        try {
            return endpointConstructorWithEndpointFactory ? endpointConstructor.newInstance(new Object[]{endpointRegistration, new EndpointInstanceFactory(endpoint), null, encodingFactory, null}) : endpointConstructor.newInstance(new Object[]{endpointRegistration, new EndpointInstanceFactory(endpoint), null, encodingFactory});
        }
        catch (Exception ex) {
            throw new HandshakeFailureException("Failed to instantiate ConfiguredServerEndpoint", ex);
        }
    }

    static {
        try {
            Class<ServletWebSocketHttpExchange> exchangeType = ServletWebSocketHttpExchange.class;
            Class[] exchangeParamTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, Set.class};
            Constructor exchangeCtor = ClassUtils.getConstructorIfAvailable(exchangeType, (Class[])exchangeParamTypes);
            if (exchangeCtor != null) {
                exchangeConstructor = exchangeCtor;
                exchangeConstructorWithPeerConnections = true;
            } else {
                exchangeParamTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
                exchangeConstructor = exchangeType.getConstructor(exchangeParamTypes);
                exchangeConstructorWithPeerConnections = false;
            }
            Class<ConfiguredServerEndpoint> endpointType = ConfiguredServerEndpoint.class;
            Class[] endpointParamTypes = new Class[]{ServerEndpointConfig.class, InstanceFactory.class, PathTemplate.class, EncodingFactory.class, AnnotatedEndpointFactory.class};
            Constructor endpointCtor = ClassUtils.getConstructorIfAvailable(endpointType, (Class[])endpointParamTypes);
            if (endpointCtor != null) {
                endpointConstructor = endpointCtor;
                endpointConstructorWithEndpointFactory = true;
            } else {
                endpointParamTypes = new Class[]{ServerEndpointConfig.class, InstanceFactory.class, PathTemplate.class, EncodingFactory.class};
                endpointConstructor = endpointType.getConstructor(endpointParamTypes);
                endpointConstructorWithEndpointFactory = false;
            }
            getBufferPoolMethod = WebSocketHttpExchange.class.getMethod("getBufferPool", new Class[0]);
            createChannelMethod = ReflectionUtils.findMethod(Handshake.class, (String)"createChannel", (Class[])null);
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Incompatible Undertow API version", ex);
        }
        supportedVersions = new String[]{WebSocketVersion.V13.toHttpHeaderValue(), WebSocketVersion.V08.toHttpHeaderValue(), WebSocketVersion.V07.toHttpHeaderValue()};
    }

    private static class EndpointInstanceFactory
    implements InstanceFactory<Endpoint> {
        private final Endpoint endpoint;

        public EndpointInstanceFactory(Endpoint endpoint) {
            this.endpoint = endpoint;
        }

        public InstanceHandle<Endpoint> createInstance() throws InstantiationException {
            return new InstanceHandle<Endpoint>(){

                public Endpoint getInstance() {
                    return EndpointInstanceFactory.this.endpoint;
                }

                public void release() {
                }
            };
        }
    }
}

