/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.support.DefaultActiveProfilesResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

abstract class ActiveProfilesUtils {
    private static final Log logger = LogFactory.getLog(ActiveProfilesUtils.class);
    private static final DefaultActiveProfilesResolver defaultActiveProfilesResolver = new DefaultActiveProfilesResolver();

    ActiveProfilesUtils() {
    }

    static String[] resolveActiveProfiles(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        TreeSet<String> activeProfiles = new TreeSet<String>();
        TestContextAnnotationUtils.AnnotationDescriptor<ActiveProfiles> descriptor = TestContextAnnotationUtils.findAnnotationDescriptor(testClass, ActiveProfiles.class);
        if (descriptor == null && logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", ActiveProfiles.class.getName(), testClass.getName()));
        }
        while (descriptor != null) {
            ActiveProfilesResolver resolver;
            Class<? extends ActiveProfilesResolver> resolverClass;
            Class<?> rootDeclaringClass = descriptor.getRootDeclaringClass();
            ActiveProfiles annotation = descriptor.getAnnotation();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @ActiveProfiles [%s] for declaring class [%s]", annotation, descriptor.getDeclaringClass().getName()));
            }
            if (ActiveProfilesResolver.class == (resolverClass = annotation.resolver())) {
                resolver = defaultActiveProfilesResolver;
            } else {
                try {
                    resolver = (ActiveProfilesResolver)BeanUtils.instantiateClass(resolverClass, ActiveProfilesResolver.class);
                }
                catch (Exception ex) {
                    String msg = String.format("Could not instantiate ActiveProfilesResolver of type [%s] for test class [%s]", resolverClass.getName(), rootDeclaringClass.getName());
                    logger.error((Object)msg);
                    throw new IllegalStateException(msg, ex);
                }
            }
            Object[] profiles = resolver.resolve(rootDeclaringClass);
            if (!ObjectUtils.isEmpty((Object[])profiles)) {
                for (Object profile : profiles) {
                    if (!StringUtils.hasText((String)profile)) continue;
                    activeProfiles.add(((String)profile).trim());
                }
            }
            descriptor = annotation.inheritProfiles() ? descriptor.next() : null;
        }
        return StringUtils.toStringArray(activeProfiles);
    }
}

