/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public final class StringDecoder
extends AbstractDataBufferDecoder<String> {
    private static final DataBuffer END_FRAME = new DefaultDataBufferFactory().wrap(new byte[0]);
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final List<String> DEFAULT_DELIMITERS = Arrays.asList("\r\n", "\n");
    private static final List<byte[]> DEFAULT_DELIMITER_BYTES = DEFAULT_DELIMITERS.stream().map(s -> s.getBytes(StandardCharsets.UTF_8)).collect(Collectors.toList());
    @Nullable
    private final List<String> delimiters;
    private final boolean stripDelimiter;

    private StringDecoder(@Nullable List<String> delimiters, boolean stripDelimiter, MimeType ... mimeTypes) {
        super(mimeTypes);
        this.delimiters = delimiters != null ? new ArrayList<String>(delimiters) : null;
        this.stripDelimiter = stripDelimiter;
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return super.canDecode(elementType, mimeType) && String.class.equals(elementType.getRawClass());
    }

    @Override
    public Flux<String> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        List<byte[]> delimiterBytes = this.delimiters != null ? this.delimiters.stream().map(s -> s.getBytes(StringDecoder.getCharset(mimeType))).collect(Collectors.toList()) : DEFAULT_DELIMITER_BYTES;
        Flux inputFlux = Flux.from(inputStream).flatMapIterable(dataBuffer -> this.splitOnDelimiter((DataBuffer)dataBuffer, delimiterBytes)).bufferUntil(StringDecoder::isEndFrame).map(StringDecoder::joinUntilEndFrame).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release);
        return super.decode((Publisher<DataBuffer>)inputFlux, elementType, mimeType, hints);
    }

    private List<DataBuffer> splitOnDelimiter(DataBuffer dataBuffer, List<byte[]> delimiterBytes) {
        ArrayList<DataBuffer> frames = new ArrayList<DataBuffer>();
        do {
            DataBuffer frame;
            int length = Integer.MAX_VALUE;
            byte[] matchingDelimiter = null;
            for (byte[] delimiter : delimiterBytes) {
                int index = StringDecoder.indexOf(dataBuffer, delimiter);
                if (index < 0 || index >= length) continue;
                length = index;
                matchingDelimiter = delimiter;
            }
            int readPosition = dataBuffer.readPosition();
            if (matchingDelimiter != null) {
                frame = this.stripDelimiter ? dataBuffer.slice(readPosition, length) : dataBuffer.slice(readPosition, length + matchingDelimiter.length);
                dataBuffer.readPosition(readPosition + length + matchingDelimiter.length);
                frames.add(DataBufferUtils.retain(frame));
                frames.add(END_FRAME);
                continue;
            }
            frame = dataBuffer.slice(readPosition, dataBuffer.readableByteCount());
            dataBuffer.readPosition(readPosition + dataBuffer.readableByteCount());
            frames.add(DataBufferUtils.retain(frame));
        } while (dataBuffer.readableByteCount() > 0);
        DataBufferUtils.release(dataBuffer);
        return frames;
    }

    private static int indexOf(DataBuffer dataBuffer, byte[] delimiter) {
        for (int i = dataBuffer.readPosition(); i < dataBuffer.writePosition(); ++i) {
            int delimiterPos;
            int dataBufferPos = i;
            for (delimiterPos = 0; delimiterPos < delimiter.length && dataBuffer.getByte(dataBufferPos) == delimiter[delimiterPos]; ++delimiterPos) {
                if (++dataBufferPos != dataBuffer.writePosition() || delimiterPos == delimiter.length - 1) continue;
                return -1;
            }
            if (delimiterPos != delimiter.length) continue;
            return i - dataBuffer.readPosition();
        }
        return -1;
    }

    private static boolean isEndFrame(DataBuffer dataBuffer) {
        return dataBuffer == END_FRAME;
    }

    private static DataBuffer joinUntilEndFrame(List<DataBuffer> dataBuffers) {
        int lastIdx;
        if (!dataBuffers.isEmpty() && StringDecoder.isEndFrame(dataBuffers.get(lastIdx = dataBuffers.size() - 1))) {
            dataBuffers.remove(lastIdx);
        }
        return dataBuffers.get(0).factory().join(dataBuffers);
    }

    @Override
    protected String decodeDataBuffer(DataBuffer dataBuffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Charset charset = StringDecoder.getCharset(mimeType);
        CharBuffer charBuffer = charset.decode(dataBuffer.asByteBuffer());
        DataBufferUtils.release(dataBuffer);
        String value = charBuffer.toString();
        LogFormatUtils.traceDebug(this.logger, traceOn -> {
            String formatted = LogFormatUtils.formatValue(value, traceOn == false);
            return Hints.getLogPrefix(hints) + "Decoded " + formatted;
        });
        return value;
    }

    private static Charset getCharset(@Nullable MimeType mimeType) {
        if (mimeType != null && mimeType.getCharset() != null) {
            return mimeType.getCharset();
        }
        return DEFAULT_CHARSET;
    }

    @Deprecated
    public static StringDecoder textPlainOnly(boolean ignored) {
        return StringDecoder.textPlainOnly();
    }

    public static StringDecoder textPlainOnly() {
        return StringDecoder.textPlainOnly(null, true);
    }

    public static StringDecoder textPlainOnly(@Nullable List<String> delimiters, boolean stripDelimiter) {
        return new StringDecoder(delimiters, stripDelimiter, new MimeType("text", "plain", DEFAULT_CHARSET));
    }

    @Deprecated
    public static StringDecoder allMimeTypes(boolean ignored) {
        return StringDecoder.allMimeTypes();
    }

    public static StringDecoder allMimeTypes() {
        return StringDecoder.allMimeTypes(null, true);
    }

    public static StringDecoder allMimeTypes(@Nullable List<String> delimiters, boolean stripDelimiter) {
        return new StringDecoder(delimiters, stripDelimiter, new MimeType("text", "plain", DEFAULT_CHARSET), MimeTypeUtils.ALL);
    }
}

