/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public abstract class CollectionFactory {
    private static final Set<Class<?>> approximableCollectionTypes = new HashSet(10);
    private static final Set<Class<?>> approximableMapTypes = new HashSet(6);

    public static boolean isApproximableCollectionType(Class<?> collectionType) {
        return collectionType != null && approximableCollectionTypes.contains(collectionType);
    }

    public static <E> Collection<E> createApproximateCollection(Object collection, int capacity) {
        if (collection instanceof LinkedList) {
            return new LinkedList();
        }
        if (collection instanceof List) {
            return new ArrayList(capacity);
        }
        if (collection instanceof EnumSet) {
            return EnumSet.copyOf((Collection)collection);
        }
        if (collection instanceof SortedSet) {
            return new TreeSet(((SortedSet)collection).comparator());
        }
        return new LinkedHashSet(capacity);
    }

    public static <E> Collection<E> createCollection(Class<?> collectionClass, int capacity) {
        return CollectionFactory.createCollection(collectionClass, null, capacity);
    }

    public static <E> Collection<E> createCollection(Class<?> collectionClass, Class<?> elementType, int capacity) {
        if (collectionClass.isInterface()) {
            if (Set.class.equals(collectionClass) || Collection.class.equals(collectionClass)) {
                return new LinkedHashSet(capacity);
            }
            if (List.class.equals(collectionClass)) {
                return new ArrayList(capacity);
            }
            if (SortedSet.class.equals(collectionClass) || NavigableSet.class.equals(collectionClass)) {
                return new TreeSet();
            }
            throw new IllegalArgumentException("Unsupported Collection interface: " + collectionClass.getName());
        }
        if (EnumSet.class.equals(collectionClass)) {
            Assert.notNull(elementType, "Cannot create EnumSet for unknown element type");
            return EnumSet.noneOf(elementType);
        }
        if (!Collection.class.isAssignableFrom(collectionClass)) {
            throw new IllegalArgumentException("Unsupported Collection type: " + collectionClass.getName());
        }
        try {
            return (Collection)collectionClass.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not instantiate Collection type: " + collectionClass.getName(), ex);
        }
    }

    public static boolean isApproximableMapType(Class<?> mapType) {
        return mapType != null && approximableMapTypes.contains(mapType);
    }

    public static <K, V> Map<K, V> createApproximateMap(Object map, int capacity) {
        if (map instanceof EnumMap) {
            return new EnumMap((Map)map);
        }
        if (map instanceof SortedMap) {
            return new TreeMap(((SortedMap)map).comparator());
        }
        return new LinkedHashMap(capacity);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapClass, int capacity) {
        return CollectionFactory.createMap(mapClass, null, capacity);
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapClass, Class<?> keyType, int capacity) {
        if (mapClass.isInterface()) {
            if (Map.class.equals(mapClass)) {
                return new LinkedHashMap(capacity);
            }
            if (SortedMap.class.equals(mapClass) || NavigableMap.class.equals(mapClass)) {
                return new TreeMap();
            }
            if (MultiValueMap.class.equals(mapClass)) {
                return new LinkedMultiValueMap();
            }
            throw new IllegalArgumentException("Unsupported Map interface: " + mapClass.getName());
        }
        if (EnumMap.class.equals(mapClass)) {
            Assert.notNull(keyType, "Cannot create EnumMap for unknown key type");
            return new EnumMap(keyType);
        }
        if (!Map.class.isAssignableFrom(mapClass)) {
            throw new IllegalArgumentException("Unsupported Map type: " + mapClass.getName());
        }
        try {
            return (Map)mapClass.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not instantiate Map type: " + mapClass.getName(), ex);
        }
    }

    static {
        approximableCollectionTypes.add(Collection.class);
        approximableCollectionTypes.add(List.class);
        approximableCollectionTypes.add(Set.class);
        approximableCollectionTypes.add(SortedSet.class);
        approximableCollectionTypes.add(NavigableSet.class);
        approximableMapTypes.add(Map.class);
        approximableMapTypes.add(SortedMap.class);
        approximableMapTypes.add(NavigableMap.class);
        approximableCollectionTypes.add(ArrayList.class);
        approximableCollectionTypes.add(LinkedList.class);
        approximableCollectionTypes.add(HashSet.class);
        approximableCollectionTypes.add(LinkedHashSet.class);
        approximableCollectionTypes.add(TreeSet.class);
        approximableCollectionTypes.add(EnumSet.class);
        approximableMapTypes.add(HashMap.class);
        approximableMapTypes.add(LinkedHashMap.class);
        approximableMapTypes.add(TreeMap.class);
        approximableMapTypes.add(EnumMap.class);
    }
}

