/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.web.http;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface CookieSerializer {
    public void writeCookieValue(CookieValue var1);

    public List<String> readCookieValues(HttpServletRequest var1);

    public static class CookieValue {
        private final HttpServletRequest request;
        private final HttpServletResponse response;
        private final String cookieValue;
        private int cookieMaxAge = -1;

        CookieValue(HttpServletRequest request, HttpServletResponse response, String cookieValue) {
            this.request = request;
            this.response = response;
            this.cookieValue = cookieValue;
            if ("".equals(this.cookieValue)) {
                this.cookieMaxAge = 0;
            }
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HttpServletResponse getResponse() {
            return this.response;
        }

        public String getCookieValue() {
            return this.cookieValue;
        }

        public int getCookieMaxAge() {
            return this.cookieMaxAge;
        }

        public void setCookieMaxAge(int cookieMaxAge) {
            this.cookieMaxAge = cookieMaxAge;
        }
    }
}

