/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.restdocs.payload.ContentHandler;
import org.springframework.restdocs.payload.FieldDescriptor;
import org.springframework.restdocs.payload.FieldDoesNotExistException;
import org.springframework.restdocs.payload.FieldTypesDoNotMatchException;
import org.springframework.restdocs.payload.JsonFieldProcessor;
import org.springframework.restdocs.payload.JsonFieldType;
import org.springframework.restdocs.payload.JsonFieldTypeResolver;
import org.springframework.restdocs.payload.PayloadHandlingException;
import org.springframework.restdocs.payload.SubsectionDescriptor;

class JsonContentHandler
implements ContentHandler {
    private final JsonFieldProcessor fieldProcessor = new JsonFieldProcessor();
    private final JsonFieldTypeResolver fieldTypeResolver = new JsonFieldTypeResolver();
    private final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private final byte[] rawContent;

    JsonContentHandler(byte[] content) {
        this.rawContent = content;
        this.readContent();
    }

    @Override
    public List<FieldDescriptor> findMissingFields(List<FieldDescriptor> fieldDescriptors) {
        ArrayList<FieldDescriptor> missingFields = new ArrayList<FieldDescriptor>();
        Object payload = this.readContent();
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            if (fieldDescriptor.isOptional() || this.fieldProcessor.hasField(fieldDescriptor.getPath(), payload) || this.isNestedBeneathMissingOptionalField(fieldDescriptor, fieldDescriptors, payload)) continue;
            missingFields.add(fieldDescriptor);
        }
        return missingFields;
    }

    private boolean isNestedBeneathMissingOptionalField(FieldDescriptor missing, List<FieldDescriptor> fieldDescriptors, Object payload) {
        ArrayList<FieldDescriptor> candidates = new ArrayList<FieldDescriptor>(fieldDescriptors);
        candidates.remove(missing);
        for (FieldDescriptor candidate : candidates) {
            if (!candidate.isOptional() || !missing.getPath().startsWith(candidate.getPath()) || !this.isMissing(candidate, payload)) continue;
            return true;
        }
        return false;
    }

    private boolean isMissing(FieldDescriptor candidate, Object payload) {
        if (!this.fieldProcessor.hasField(candidate.getPath(), payload)) {
            return true;
        }
        JsonFieldProcessor.ExtractedField extracted = this.fieldProcessor.extract(candidate.getPath(), payload);
        return this.isEmptyCollection(extracted.getValue());
    }

    private boolean isEmptyCollection(Object value) {
        if (!(value instanceof Collection)) {
            return false;
        }
        Collection collection = (Collection)value;
        if (collection.isEmpty()) {
            return true;
        }
        for (Object entry : collection) {
            if (this.isEmptyCollection(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getUndocumentedContent(List<FieldDescriptor> fieldDescriptors) {
        Object content = this.readContent();
        for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
            if (this.describesSubsection(fieldDescriptor)) {
                this.fieldProcessor.removeSubsection(fieldDescriptor.getPath(), content);
                continue;
            }
            this.fieldProcessor.remove(fieldDescriptor.getPath(), content);
        }
        if (!this.isEmpty(content)) {
            try {
                return this.objectMapper.writeValueAsString(content);
            }
            catch (JsonProcessingException ex) {
                throw new PayloadHandlingException(ex);
            }
        }
        return null;
    }

    private boolean describesSubsection(FieldDescriptor fieldDescriptor) {
        return fieldDescriptor instanceof SubsectionDescriptor;
    }

    private Object readContent() {
        try {
            return new ObjectMapper().readValue(this.rawContent, Object.class);
        }
        catch (IOException ex) {
            throw new PayloadHandlingException(ex);
        }
    }

    private boolean isEmpty(Object object) {
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        return ((List)object).isEmpty();
    }

    @Override
    public Object determineFieldType(FieldDescriptor fieldDescriptor) {
        if (fieldDescriptor.getType() == null) {
            return this.fieldTypeResolver.resolveFieldType(fieldDescriptor, this.readContent());
        }
        if (!(fieldDescriptor.getType() instanceof JsonFieldType)) {
            return fieldDescriptor.getType();
        }
        JsonFieldType descriptorFieldType = (JsonFieldType)((Object)fieldDescriptor.getType());
        try {
            JsonFieldType actualFieldType = this.fieldTypeResolver.resolveFieldType(fieldDescriptor, this.readContent());
            if (descriptorFieldType == JsonFieldType.VARIES || descriptorFieldType == actualFieldType || fieldDescriptor.isOptional() && actualFieldType == JsonFieldType.NULL) {
                return descriptorFieldType;
            }
            throw new FieldTypesDoNotMatchException(fieldDescriptor, (Object)actualFieldType);
        }
        catch (FieldDoesNotExistException ex) {
            return fieldDescriptor.getType();
        }
    }
}

