/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.restdocs.payload;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.restdocs.payload.JsonFieldPath;
import org.springframework.restdocs.payload.JsonFieldProcessor;
import org.springframework.restdocs.payload.PayloadHandlingException;
import org.springframework.restdocs.payload.PayloadSubsectionExtractor;

public class FieldPathPayloadSubsectionExtractor
implements PayloadSubsectionExtractor<FieldPathPayloadSubsectionExtractor> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final String fieldPath;
    private final String subsectionId;

    protected FieldPathPayloadSubsectionExtractor(String fieldPath) {
        this(fieldPath, "beneath-" + fieldPath);
    }

    protected FieldPathPayloadSubsectionExtractor(String fieldPath, String subsectionId) {
        this.fieldPath = fieldPath;
        this.subsectionId = subsectionId;
    }

    @Override
    public byte[] extractSubsection(byte[] payload, MediaType contentType) {
        try {
            JsonFieldProcessor.ExtractedField extractedField = new JsonFieldProcessor().extract(this.fieldPath, objectMapper.readValue(payload, Object.class));
            Object value = extractedField.getValue();
            if (value instanceof List && extractedField.getType() == JsonFieldPath.PathType.MULTI) {
                List extractedList = (List)value;
                if (extractedList.size() == 1) {
                    value = extractedList.get(0);
                } else {
                    throw new PayloadHandlingException(this.fieldPath + " does not uniquely identify a subsection of the payload");
                }
            }
            return objectMapper.writeValueAsBytes(value);
        }
        catch (IOException ex) {
            throw new PayloadHandlingException(ex);
        }
    }

    @Override
    public String getSubsectionId() {
        return this.subsectionId;
    }

    protected String getFieldPath() {
        return this.fieldPath;
    }

    @Override
    public FieldPathPayloadSubsectionExtractor withSubsectionId(String subsectionId) {
        return new FieldPathPayloadSubsectionExtractor(this.fieldPath, subsectionId);
    }
}

