/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.List;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.context.Orderable;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.handler.AbstractMessageProducingHandler;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.integration.support.context.NamedComponent;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class AbstractSimpleMessageHandlerFactoryBean<H extends MessageHandler>
implements FactoryBean<MessageHandler>,
ApplicationContextAware,
BeanFactoryAware,
BeanNameAware,
ApplicationEventPublisherAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private volatile H handler;
    private volatile MessageChannel outputChannel;
    private volatile Integer order;
    private BeanFactory beanFactory;
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();
    private volatile List<Advice> adviceChain;
    private volatile String componentName;
    private ApplicationContext applicationContext;
    private String beanName;
    private ApplicationEventPublisher applicationEventPublisher;
    private DestinationResolver<MessageChannel> channelResolver;
    private Boolean async;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setChannelResolver(DestinationResolver<MessageChannel> channelResolver) {
        this.channelResolver = channelResolver;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    protected BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setAdviceChain(List<Advice> adviceChain) {
        this.adviceChain = adviceChain;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public H getObject() throws Exception {
        if (this.handler == null) {
            this.handler = this.createHandlerInternal();
            Assert.notNull(this.handler, (String)"failed to create MessageHandler");
        }
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final H createHandlerInternal() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            Object actualHandler;
            if (this.initialized) {
                return null;
            }
            this.handler = this.createHandler();
            if (this.handler instanceof ApplicationContextAware && this.applicationContext != null) {
                ((ApplicationContextAware)this.handler).setApplicationContext(this.applicationContext);
            }
            if (this.handler instanceof BeanFactoryAware && this.getBeanFactory() != null) {
                ((BeanFactoryAware)this.handler).setBeanFactory(this.getBeanFactory());
            }
            if (this.handler instanceof BeanNameAware && this.beanName != null) {
                ((BeanNameAware)this.handler).setBeanName(this.beanName);
            }
            if (this.handler instanceof ApplicationEventPublisherAware && this.applicationEventPublisher != null) {
                ((ApplicationEventPublisherAware)this.handler).setApplicationEventPublisher(this.applicationEventPublisher);
            }
            if (this.handler instanceof MessageProducer && this.outputChannel != null) {
                ((MessageProducer)this.handler).setOutputChannel(this.outputChannel);
            }
            if ((actualHandler = this.extractTarget(this.handler)) == null) {
                actualHandler = this.handler;
            }
            if (actualHandler instanceof IntegrationObjectSupport) {
                if (this.componentName != null) {
                    ((IntegrationObjectSupport)actualHandler).setComponentName(this.componentName);
                }
                if (this.channelResolver != null) {
                    ((IntegrationObjectSupport)actualHandler).setChannelResolver(this.channelResolver);
                }
            }
            if (!CollectionUtils.isEmpty(this.adviceChain)) {
                if (actualHandler instanceof AbstractReplyProducingMessageHandler) {
                    ((AbstractReplyProducingMessageHandler)actualHandler).setAdviceChain(this.adviceChain);
                } else if (this.logger.isDebugEnabled()) {
                    String name = this.componentName;
                    if (name == null && actualHandler instanceof NamedComponent) {
                        name = ((NamedComponent)actualHandler).getComponentName();
                    }
                    this.logger.debug((Object)("adviceChain can only be set on an AbstractReplyProducingMessageHandler" + (name == null ? "" : ", " + name) + "."));
                }
            }
            if (this.async != null && actualHandler instanceof AbstractMessageProducingHandler) {
                ((AbstractMessageProducingHandler)actualHandler).setAsync(this.async);
            }
            if (this.handler instanceof Orderable && this.order != null) {
                ((Orderable)this.handler).setOrder(this.order);
            }
            this.initialized = true;
        }
        if (this.handler instanceof InitializingBean) {
            try {
                ((InitializingBean)this.handler).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new BeanInitializationException("failed to initialize MessageHandler", (Throwable)e);
            }
        }
        return this.handler;
    }

    protected abstract H createHandler();

    public Class<? extends MessageHandler> getObjectType() {
        if (this.handler != null) {
            return this.handler.getClass();
        }
        return this.getPreCreationHandlerType();
    }

    protected Class<? extends MessageHandler> getPreCreationHandlerType() {
        return MessageHandler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private Object extractTarget(Object object) {
        if (!(object instanceof Advised)) {
            return object;
        }
        Advised advised = (Advised)object;
        try {
            return this.extractTarget(advised.getTargetSource().getTarget());
        }
        catch (Exception e) {
            this.logger.error((Object)"Could not extract target", (Throwable)e);
            return null;
        }
    }
}

