/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.transformer.Transformer;
import org.springframework.integration.transformer.support.HeaderValueMessageProcessor;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;

public class HeaderEnricher
extends IntegrationObjectSupport
implements Transformer,
BeanNameAware,
InitializingBean {
    private final Map<String, ? extends HeaderValueMessageProcessor<?>> headersToAdd;
    private volatile MessageProcessor<?> messageProcessor;
    private volatile boolean defaultOverwrite = false;
    private volatile boolean shouldSkipNulls = true;

    public HeaderEnricher() {
        this(null);
    }

    public HeaderEnricher(Map<String, ? extends HeaderValueMessageProcessor<?>> headersToAdd) {
        this.headersToAdd = headersToAdd != null ? headersToAdd : new HashMap();
    }

    public <T> void setMessageProcessor(MessageProcessor<T> messageProcessor) {
        this.messageProcessor = messageProcessor;
    }

    public void setDefaultOverwrite(boolean defaultOverwrite) {
        this.defaultOverwrite = defaultOverwrite;
    }

    public void setShouldSkipNulls(boolean shouldSkipNulls) {
        this.shouldSkipNulls = shouldSkipNulls;
    }

    @Override
    public String getComponentType() {
        return "transformer";
    }

    @Override
    public Message<?> transform(Message<?> message) {
        try {
            HashMap<String, Object> headerMap = new HashMap<String, Object>((Map<String, Object>)message.getHeaders());
            this.addHeadersFromMessageProcessor(message, headerMap);
            for (Map.Entry<String, HeaderValueMessageProcessor<?>> entry : this.headersToAdd.entrySet()) {
                Object value;
                boolean headerDoesNotExist;
                String key = entry.getKey();
                HeaderValueMessageProcessor<?> valueProcessor = entry.getValue();
                Boolean shouldOverwrite = valueProcessor.isOverwrite();
                if (shouldOverwrite == null) {
                    shouldOverwrite = this.defaultOverwrite;
                }
                boolean bl = headerDoesNotExist = headerMap.get(key) == null;
                if (!headerDoesNotExist && !shouldOverwrite.booleanValue() || (value = valueProcessor.processMessage(message)) == null && this.shouldSkipNulls) continue;
                headerMap.put(key, value);
            }
            return this.getMessageBuilderFactory().withPayload(message.getPayload()).copyHeaders(headerMap).build();
        }
        catch (Exception e) {
            throw new MessagingException(message, "failed to transform message headers", (Throwable)e);
        }
    }

    private void addHeadersFromMessageProcessor(Message<?> message, Map<String, Object> headerMap) {
        if (this.messageProcessor != null) {
            Object result = this.messageProcessor.processMessage(message);
            if (result instanceof Map) {
                Map resultMap = (Map)result;
                for (Map.Entry entry : resultMap.entrySet()) {
                    Object key = entry.getKey();
                    if (key instanceof String) {
                        if (!this.defaultOverwrite && headerMap.get(key) != null) continue;
                        headerMap.put((String)key, entry.getValue());
                        continue;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("ignoring value for non-String key: " + key));
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("expected a Map result from processor, but received: " + result));
            }
        }
    }

    @Override
    public void onInit() throws Exception {
        boolean shouldOverwrite = this.defaultOverwrite;
        boolean checkReadOnlyHeaders = this.getMessageBuilderFactory() instanceof DefaultMessageBuilderFactory;
        for (Map.Entry<String, HeaderValueMessageProcessor<?>> entry : this.headersToAdd.entrySet()) {
            Boolean processorOverwrite;
            HeaderValueMessageProcessor<?> processor;
            if (checkReadOnlyHeaders && ("id".equals(entry.getKey()) || "timestamp".equals(entry.getKey()))) {
                this.logger.warn((Object)("HeaderEnricher cannot override 'id' and 'timestamp' read-only headers.\nWrong 'headersToAdd' [" + this.headersToAdd + "] configuration for " + this.getComponentName()));
            }
            if ((processor = entry.getValue()) instanceof BeanFactoryAware && this.getBeanFactory() != null) {
                ((BeanFactoryAware)processor).setBeanFactory(this.getBeanFactory());
            }
            if ((processorOverwrite = processor.isOverwrite()) == null) continue;
            shouldOverwrite |= processorOverwrite.booleanValue();
        }
        if (this.messageProcessor != null && this.messageProcessor instanceof BeanFactoryAware && this.getBeanFactory() != null) {
            ((BeanFactoryAware)this.messageProcessor).setBeanFactory(this.getBeanFactory());
        }
        if (!shouldOverwrite && !this.shouldSkipNulls && this.logger.isWarnEnabled()) {
            this.logger.warn((Object)(this.getComponentName() + " is configured to not overwrite existing headers. 'shouldSkipNulls = false' will have no effect"));
        }
    }
}

