/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.filter.ExpressionEvaluatingSelector;
import org.springframework.integration.router.AbstractMessageRouter;
import org.springframework.integration.router.RecipientListRouterManagement;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RecipientListRouter
extends AbstractMessageRouter
implements InitializingBean,
RecipientListRouterManagement {
    private final ConcurrentLinkedQueue<Recipient> recipients = new ConcurrentLinkedQueue();

    public void setChannels(List<MessageChannel> channels) {
        Assert.notEmpty(channels, (String)"channels must not be empty");
        ArrayList<Recipient> recipients = new ArrayList<Recipient>();
        for (MessageChannel channel : channels) {
            recipients.add(new Recipient(channel));
        }
        this.setRecipients(recipients);
    }

    public void setRecipients(List<Recipient> recipients) {
        Assert.notEmpty(recipients, (String)"recipients must not be empty");
        ConcurrentLinkedQueue<Recipient> originalRecipients = this.recipients;
        this.recipients.clear();
        this.recipients.addAll(recipients);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Channel Recipients:" + originalRecipients + " replaced with:" + this.recipients));
        }
    }

    @Override
    @ManagedAttribute
    public void setRecipientMappings(Map<String, String> recipientMappings) {
        Assert.notEmpty(recipientMappings, (String)"recipientMappings must not be empty");
        Assert.noNullElements((Object[])recipientMappings.keySet().toArray(), (String)"'recipientMappings' cannot have null keys.");
        ConcurrentLinkedQueue<Recipient> originalRecipients = this.recipients;
        this.recipients.clear();
        for (Map.Entry<String, String> next : recipientMappings.entrySet()) {
            if (StringUtils.hasText((String)next.getValue())) {
                this.addRecipient(next.getKey(), next.getValue());
                continue;
            }
            this.addRecipient(next.getKey());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Channel Recipients:" + originalRecipients + " replaced with:" + this.recipients));
        }
    }

    @Override
    public String getComponentType() {
        return "recipient-list-router";
    }

    @Override
    protected Collection<MessageChannel> determineTargetChannels(Message<?> message) {
        ArrayList<MessageChannel> channels = new ArrayList<MessageChannel>();
        for (Recipient recipient : this.recipients) {
            if (!recipient.accept(message)) continue;
            channels.add(recipient.getChannel());
        }
        return channels;
    }

    @Override
    @ManagedOperation
    public void addRecipient(String channelName, String selectorExpression) {
        Assert.hasText((String)channelName, (String)"'channelName' must not be empty.");
        Assert.hasText((String)selectorExpression, (String)"'selectorExpression' must not be empty.");
        MessageChannel channel = (MessageChannel)this.getChannelResolver().resolveDestination(channelName);
        ExpressionEvaluatingSelector expressionEvaluatingSelector = new ExpressionEvaluatingSelector(selectorExpression);
        expressionEvaluatingSelector.setBeanFactory(this.getBeanFactory());
        this.recipients.add(new Recipient(channel, expressionEvaluatingSelector));
    }

    @Override
    @ManagedOperation
    public void addRecipient(String channelName) {
        Assert.hasText((String)channelName, (String)"'channelName' must not be empty.");
        MessageChannel channel = (MessageChannel)this.getChannelResolver().resolveDestination(channelName);
        this.recipients.add(new Recipient(channel));
    }

    @Override
    @ManagedOperation
    public int removeRecipient(String channelName) {
        int counter = 0;
        MessageChannel channel = (MessageChannel)this.getChannelResolver().resolveDestination(channelName);
        Iterator<Recipient> it = this.recipients.iterator();
        while (it.hasNext()) {
            if (it.next().getChannel() != channel) continue;
            it.remove();
            ++counter;
        }
        return counter;
    }

    @Override
    @ManagedOperation
    public int removeRecipient(String channelName, String selectorExpression) {
        int counter = 0;
        MessageChannel targetChannel = (MessageChannel)this.getChannelResolver().resolveDestination(channelName);
        Iterator<Recipient> it = this.recipients.iterator();
        while (it.hasNext()) {
            Recipient next = it.next();
            MessageSelector selector = next.getSelector();
            MessageChannel channel = next.getChannel();
            if (!(selector instanceof ExpressionEvaluatingSelector) || channel != targetChannel || !((ExpressionEvaluatingSelector)selector).getExpressionString().equals(selectorExpression)) continue;
            it.remove();
            ++counter;
        }
        return counter;
    }

    @ManagedAttribute
    public Collection<Recipient> getRecipients() {
        return Collections.unmodifiableCollection(this.recipients);
    }

    @Override
    @ManagedOperation
    public void replaceRecipients(Properties recipientMappings) {
        Assert.notEmpty((Map)recipientMappings, (String)"'recipientMappings' must not be empty");
        Set<String> keys = recipientMappings.stringPropertyNames();
        ConcurrentLinkedQueue<Recipient> originalRecipients = this.recipients;
        this.recipients.clear();
        for (String key : keys) {
            Assert.notNull((Object)key, (String)"channelName can't be null.");
            if (StringUtils.hasText((String)recipientMappings.getProperty(key))) {
                this.addRecipient(key, recipientMappings.getProperty(key));
                continue;
            }
            this.addRecipient(key);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Channel Recipients:" + originalRecipients + " replaced with:" + this.recipients));
        }
    }

    public static class Recipient {
        private final MessageChannel channel;
        private final MessageSelector selector;

        public Recipient(MessageChannel channel) {
            this(channel, null);
        }

        public Recipient(MessageChannel channel, MessageSelector selector) {
            this.channel = channel;
            this.selector = selector;
        }

        private MessageSelector getSelector() {
            return this.selector;
        }

        public MessageChannel getChannel() {
            return this.channel;
        }

        public boolean accept(Message<?> message) {
            return this.selector == null || this.selector.accept(message);
        }
    }
}

