/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.vault.config.VaultKeyValueBackendPropertiesSupport;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(value="spring.cloud.vault.generic")
@Validated
public class VaultGenericBackendProperties
implements EnvironmentAware,
VaultKeyValueBackendPropertiesSupport {
    private boolean enabled = true;
    @NotEmpty
    private String backend = "secret";
    @NotEmpty
    private String defaultContext = "application";
    @NotEmpty
    private String profileSeparator = "/";
    private String applicationName = "application";

    public void setEnvironment(Environment environment) {
        String springCloudVaultAppName = environment.getProperty("spring.cloud.vault.application-name");
        if (StringUtils.hasText((String)springCloudVaultAppName)) {
            this.applicationName = springCloudVaultAppName;
        } else {
            String springAppName = environment.getProperty("spring.application.name");
            if (StringUtils.hasText((String)springAppName)) {
                this.applicationName = springAppName;
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public String getBackend() {
        return this.backend;
    }

    @Override
    public String getDefaultContext() {
        return this.defaultContext;
    }

    @Override
    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBackend(String backend) {
        this.backend = backend;
    }

    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VaultGenericBackendProperties)) {
            return false;
        }
        VaultGenericBackendProperties other = (VaultGenericBackendProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$backend = this.getBackend();
        String other$backend = other.getBackend();
        if (this$backend == null ? other$backend != null : !this$backend.equals(other$backend)) {
            return false;
        }
        String this$defaultContext = this.getDefaultContext();
        String other$defaultContext = other.getDefaultContext();
        if (this$defaultContext == null ? other$defaultContext != null : !this$defaultContext.equals(other$defaultContext)) {
            return false;
        }
        String this$profileSeparator = this.getProfileSeparator();
        String other$profileSeparator = other.getProfileSeparator();
        if (this$profileSeparator == null ? other$profileSeparator != null : !this$profileSeparator.equals(other$profileSeparator)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        return !(this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VaultGenericBackendProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $backend = this.getBackend();
        result = result * 59 + ($backend == null ? 43 : $backend.hashCode());
        String $defaultContext = this.getDefaultContext();
        result = result * 59 + ($defaultContext == null ? 43 : $defaultContext.hashCode());
        String $profileSeparator = this.getProfileSeparator();
        result = result * 59 + ($profileSeparator == null ? 43 : $profileSeparator.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        return result;
    }

    public String toString() {
        return "VaultGenericBackendProperties(enabled=" + this.isEnabled() + ", backend=" + this.getBackend() + ", defaultContext=" + this.getDefaultContext() + ", profileSeparator=" + this.getProfileSeparator() + ", applicationName=" + this.getApplicationName() + ")";
    }
}

