/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.repository.support;

import javax.sql.DataSource;
import org.springframework.batch.item.database.support.DefaultDataFieldMaxValueIncrementerFactory;
import org.springframework.batch.support.DatabaseType;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.cloud.task.repository.dao.JdbcTaskExecutionDao;
import org.springframework.cloud.task.repository.dao.MapTaskExecutionDao;
import org.springframework.cloud.task.repository.dao.TaskExecutionDao;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.util.Assert;

public class TaskExecutionDaoFactoryBean
implements FactoryBean<TaskExecutionDao> {
    private DataSource dataSource;
    private TaskExecutionDao dao = null;
    private String tablePrefix = "TASK_";

    public TaskExecutionDaoFactoryBean() {
    }

    public TaskExecutionDaoFactoryBean(DataSource dataSource, String tablePrefix) {
        this(dataSource);
        Assert.hasText((String)tablePrefix, (String)"tablePrefix must not be null nor empty");
        this.tablePrefix = tablePrefix;
    }

    public TaskExecutionDaoFactoryBean(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"A DataSource is required");
        this.dataSource = dataSource;
    }

    public TaskExecutionDao getObject() throws Exception {
        if (this.dao == null) {
            if (this.dataSource != null) {
                this.buildTaskExecutionDao(this.dataSource);
            } else {
                this.dao = new MapTaskExecutionDao();
            }
        }
        return this.dao;
    }

    public Class<?> getObjectType() {
        return TaskExecutionDao.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void buildTaskExecutionDao(DataSource dataSource) {
        String databaseType;
        DefaultDataFieldMaxValueIncrementerFactory incrementerFactory = new DefaultDataFieldMaxValueIncrementerFactory(dataSource);
        this.dao = new JdbcTaskExecutionDao(dataSource, this.tablePrefix);
        try {
            databaseType = DatabaseType.fromMetaData((DataSource)dataSource).name();
        }
        catch (MetaDataAccessException e) {
            throw new IllegalStateException(e);
        }
        ((JdbcTaskExecutionDao)this.dao).setTaskIncrementer(incrementerFactory.getIncrementer(databaseType, this.tablePrefix + "SEQ"));
    }
}

