/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.listener;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.aop.scope.ScopedObject;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.task.listener.TaskExecutionListener;
import org.springframework.cloud.task.listener.annotation.AfterTask;
import org.springframework.cloud.task.listener.annotation.BeforeTask;
import org.springframework.cloud.task.listener.annotation.FailedTask;
import org.springframework.cloud.task.listener.annotation.TaskListenerExecutor;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotationUtils;

public class TaskListenerExecutorObjectFactory
implements ObjectFactory<TaskExecutionListener> {
    private static final Log logger = LogFactory.getLog(TaskListenerExecutor.class);
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private ConfigurableApplicationContext context;
    private Map<Method, Object> beforeTaskInstances;
    private Map<Method, Object> afterTaskInstances;
    private Map<Method, Object> failedTaskInstances;

    public TaskListenerExecutorObjectFactory(ConfigurableApplicationContext context) {
        this.context = context;
    }

    public TaskListenerExecutor getObject() {
        this.beforeTaskInstances = new HashMap<Method, Object>();
        this.afterTaskInstances = new HashMap<Method, Object>();
        this.failedTaskInstances = new HashMap<Method, Object>();
        this.initializeExecutor();
        return new TaskListenerExecutor(this.beforeTaskInstances, this.afterTaskInstances, this.failedTaskInstances);
    }

    private void initializeExecutor() {
        ConfigurableListableBeanFactory factory = this.context.getBeanFactory();
        for (String beanName : this.context.getBeanDefinitionNames()) {
            Class type;
            block9: {
                block8: {
                    if (ScopedProxyUtils.isScopedTarget((String)beanName)) continue;
                    type = null;
                    try {
                        type = AutoProxyUtils.determineTargetClass((ConfigurableListableBeanFactory)factory, (String)beanName);
                    }
                    catch (RuntimeException ex) {
                        if (!logger.isDebugEnabled()) break block8;
                        logger.debug((Object)("Could not resolve target class for bean with name '" + beanName + "'"), (Throwable)ex);
                    }
                }
                if (type == null) continue;
                if (ScopedObject.class.isAssignableFrom(type)) {
                    try {
                        type = AutoProxyUtils.determineTargetClass((ConfigurableListableBeanFactory)factory, (String)ScopedProxyUtils.getTargetBeanName((String)beanName));
                    }
                    catch (RuntimeException ex) {
                        if (!logger.isDebugEnabled()) break block9;
                        logger.debug((Object)("Could not resolve target bean for scoped proxy '" + beanName + "'"), (Throwable)ex);
                    }
                }
            }
            try {
                this.processBean(beanName, type);
            }
            catch (RuntimeException ex) {
                throw new BeanInitializationException("Failed to process @BeforeTask annotation on bean with name '" + beanName + "'", (Throwable)ex);
            }
        }
    }

    private void processBean(String beanName, Class<?> type) {
        if (!this.nonAnnotatedClasses.contains(type)) {
            Map<Method, BeforeTask> beforeTaskMethods = new MethodGetter<BeforeTask>().getMethods(type, BeforeTask.class);
            Map<Method, AfterTask> afterTaskMethods = new MethodGetter<AfterTask>().getMethods(type, AfterTask.class);
            Map<Method, FailedTask> failedTaskMethods = new MethodGetter<FailedTask>().getMethods(type, FailedTask.class);
            if (beforeTaskMethods.isEmpty() && afterTaskMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(type);
                return;
            }
            if (!beforeTaskMethods.isEmpty()) {
                for (Method beforeTaskMethod : beforeTaskMethods.keySet()) {
                    this.beforeTaskInstances.put(beforeTaskMethod, this.context.getBean(beanName));
                }
            }
            if (!afterTaskMethods.isEmpty()) {
                for (Method afterTaskMethod : afterTaskMethods.keySet()) {
                    this.afterTaskInstances.put(afterTaskMethod, this.context.getBean(beanName));
                }
            }
            if (!failedTaskMethods.isEmpty()) {
                for (Method failedTaskMethod : failedTaskMethods.keySet()) {
                    this.failedTaskInstances.put(failedTaskMethod, this.context.getBean(beanName));
                }
            }
        }
    }

    private static class MethodGetter<T extends Annotation> {
        private MethodGetter() {
        }

        public Map<Method, T> getMethods(Class<?> type, Class<T> annotationClass) {
            return MethodIntrospector.selectMethods(type, method -> AnnotationUtils.findAnnotation((Method)method, (Class)annotationClass));
        }
    }
}

