/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.task.listener;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ExitCodeEvent;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.context.event.ApplicationFailedEvent;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.task.configuration.TaskProperties;
import org.springframework.cloud.task.listener.TaskExecutionException;
import org.springframework.cloud.task.listener.TaskExecutionListener;
import org.springframework.cloud.task.listener.TaskListenerExecutorObjectFactory;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.cloud.task.repository.TaskExplorer;
import org.springframework.cloud.task.repository.TaskNameResolver;
import org.springframework.cloud.task.repository.TaskRepository;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class TaskLifecycleListener
implements ApplicationListener<ApplicationEvent>,
SmartLifecycle,
DisposableBean {
    @Autowired
    private ConfigurableApplicationContext context;
    @Autowired(required=false)
    private Collection<TaskExecutionListener> taskExecutionListenersFromContext;
    private List<TaskExecutionListener> taskExecutionListeners;
    private static final Log logger = LogFactory.getLog(TaskLifecycleListener.class);
    private final TaskRepository taskRepository;
    private final TaskExplorer taskExplorer;
    private final TaskListenerExecutorObjectFactory taskListenerExecutorObjectFactory;
    private TaskExecution taskExecution;
    private TaskProperties taskProperties;
    private boolean started = false;
    private boolean finished = false;
    private boolean listenerFailed = false;
    private Throwable listenerException;
    private TaskNameResolver taskNameResolver;
    private ApplicationArguments applicationArguments;
    private Throwable applicationFailedException;
    private ExitCodeEvent exitCodeEvent;

    public TaskLifecycleListener(TaskRepository taskRepository, TaskNameResolver taskNameResolver, ApplicationArguments applicationArguments, TaskExplorer taskExplorer, TaskProperties taskProperties, TaskListenerExecutorObjectFactory taskListenerExecutorObjectFactory) {
        Assert.notNull((Object)taskRepository, (String)"A taskRepository is required");
        Assert.notNull((Object)taskNameResolver, (String)"A taskNameResolver is required");
        Assert.notNull((Object)taskExplorer, (String)"A taskExplorer is required");
        Assert.notNull((Object)taskProperties, (String)"TaskProperties is required");
        Assert.notNull((Object)taskListenerExecutorObjectFactory, (String)"A TaskListenerExecutorObjectFactory is required");
        this.taskRepository = taskRepository;
        this.taskNameResolver = taskNameResolver;
        this.applicationArguments = applicationArguments;
        this.taskExplorer = taskExplorer;
        this.taskProperties = taskProperties;
        this.taskListenerExecutorObjectFactory = taskListenerExecutorObjectFactory;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ApplicationFailedEvent) {
            this.applicationFailedException = ((ApplicationFailedEvent)applicationEvent).getException();
            this.doTaskEnd();
        } else if (applicationEvent instanceof ExitCodeEvent) {
            this.exitCodeEvent = (ExitCodeEvent)applicationEvent;
        } else if (applicationEvent instanceof ApplicationReadyEvent) {
            this.doTaskEnd();
        }
    }

    private String stackTraceToString(Throwable exception) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        exception.printStackTrace(printWriter);
        return writer.toString();
    }

    private void doTaskEnd() {
        if ((this.listenerFailed || this.started) && !this.finished) {
            this.taskExecution.setEndTime(new Date());
            if (this.applicationFailedException != null) {
                this.taskExecution.setErrorMessage(this.stackTraceToString(this.applicationFailedException));
            }
            this.taskExecution.setExitCode(this.calcExitStatus());
            if (this.applicationFailedException != null) {
                this.setExitMessage(this.invokeOnTaskError(this.taskExecution, this.applicationFailedException));
            }
            this.setExitMessage(this.invokeOnTaskEnd(this.taskExecution));
            this.taskRepository.completeTaskExecution(this.taskExecution.getExecutionId(), this.taskExecution.getExitCode(), this.taskExecution.getEndTime(), this.taskExecution.getExitMessage(), this.taskExecution.getErrorMessage());
            this.finished = true;
            if (this.taskProperties.getClosecontextEnabled().booleanValue() && this.context.isActive()) {
                this.context.close();
            }
        } else if (!this.started) {
            logger.error((Object)"An event to end a task has been received for a task that has not yet started.");
        }
    }

    private void setExitMessage(TaskExecution taskExecutionParam) {
        if (taskExecutionParam.getExitMessage() != null) {
            this.taskExecution.setExitMessage(taskExecutionParam.getExitMessage());
        }
    }

    private int calcExitStatus() {
        int exitCode = 0;
        if (this.exitCodeEvent != null) {
            exitCode = this.exitCodeEvent.getExitCode();
        } else if (this.listenerFailed || this.applicationFailedException != null) {
            InvocationTargetException invocationTargetException;
            TaskExecutionException taskExecutionException;
            Throwable exception = this.listenerException;
            if (exception instanceof TaskExecutionException && (taskExecutionException = (TaskExecutionException)exception).getCause() instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)taskExecutionException.getCause()) != null && invocationTargetException.getTargetException() != null) {
                exception = invocationTargetException.getTargetException();
            }
            exitCode = exception instanceof ExitCodeGenerator ? ((ExitCodeGenerator)exception).getExitCode() : 1;
        }
        return exitCode;
    }

    private void doTaskStart() {
        try {
            if (!this.started) {
                this.taskExecutionListeners = new ArrayList<TaskExecutionListener>();
                this.taskListenerExecutorObjectFactory.getObject();
                if (!CollectionUtils.isEmpty(this.taskExecutionListenersFromContext)) {
                    this.taskExecutionListeners.addAll(this.taskExecutionListenersFromContext);
                }
                this.taskExecutionListeners.add(this.taskListenerExecutorObjectFactory.getObject());
                ArrayList<String> args = new ArrayList(0);
                if (this.applicationArguments != null) {
                    args = Arrays.asList(this.applicationArguments.getSourceArgs());
                }
                if (this.taskProperties.getExecutionid() != null) {
                    TaskExecution taskExecution = this.taskExplorer.getTaskExecution(this.taskProperties.getExecutionid());
                    Assert.notNull((Object)taskExecution, (String)String.format("Invalid TaskExecution, ID %s not found", this.taskProperties.getExecutionid()));
                    Assert.isNull((Object)taskExecution.getEndTime(), (String)String.format("Invalid TaskExecution, ID %s task is already complete", this.taskProperties.getExecutionid()));
                    this.taskExecution = this.taskRepository.startTaskExecution(this.taskProperties.getExecutionid(), this.taskNameResolver.getTaskName(), new Date(), args, this.taskProperties.getExternalExecutionId(), this.taskProperties.getParentExecutionId());
                } else {
                    TaskExecution taskExecution = new TaskExecution();
                    taskExecution.setTaskName(this.taskNameResolver.getTaskName());
                    taskExecution.setStartTime(new Date());
                    taskExecution.setArguments(args);
                    taskExecution.setExternalExecutionId(this.taskProperties.getExternalExecutionId());
                    taskExecution.setParentExecutionId(this.taskProperties.getParentExecutionId());
                    this.taskExecution = this.taskRepository.createTaskExecution(taskExecution);
                }
            } else {
                logger.error((Object)"Multiple start events have been received.  The first one was recorded.");
            }
            this.setExitMessage(this.invokeOnTaskStartup(this.taskExecution));
        }
        catch (Throwable t) {
            this.applicationFailedException = t;
            this.doTaskEnd();
            throw t;
        }
    }

    private TaskExecution invokeOnTaskStartup(TaskExecution taskExecution) {
        TaskExecution listenerTaskExecution = this.getTaskExecutionCopy(taskExecution);
        ArrayList<TaskExecutionListener> startupListenerList = new ArrayList<TaskExecutionListener>(this.taskExecutionListeners);
        if (!CollectionUtils.isEmpty(startupListenerList)) {
            try {
                Collections.reverse(startupListenerList);
                for (TaskExecutionListener taskExecutionListener : startupListenerList) {
                    taskExecutionListener.onTaskStartup(listenerTaskExecution);
                }
            }
            catch (Throwable currentListenerException) {
                logger.error((Object)currentListenerException);
                this.listenerFailed = true;
                this.taskExecution.setErrorMessage(currentListenerException.getMessage());
                this.listenerException = currentListenerException;
                throw currentListenerException;
            }
        }
        return listenerTaskExecution;
    }

    private TaskExecution invokeOnTaskEnd(TaskExecution taskExecution) {
        TaskExecution listenerTaskExecution = this.getTaskExecutionCopy(taskExecution);
        if (this.taskExecutionListeners != null) {
            try {
                for (TaskExecutionListener taskExecutionListener : this.taskExecutionListeners) {
                    taskExecutionListener.onTaskEnd(listenerTaskExecution);
                }
            }
            catch (Throwable listenerException) {
                String errorMessage = this.stackTraceToString(listenerException);
                if (StringUtils.hasText((String)listenerTaskExecution.getErrorMessage())) {
                    errorMessage = String.format("%s :Task also threw this Exception: %s", errorMessage, listenerTaskExecution.getErrorMessage());
                }
                logger.error((Object)errorMessage);
                listenerTaskExecution.setErrorMessage(errorMessage);
                this.listenerFailed = true;
            }
        }
        return listenerTaskExecution;
    }

    private TaskExecution invokeOnTaskError(TaskExecution taskExecution, Throwable throwable) {
        TaskExecution listenerTaskExecution = this.getTaskExecutionCopy(taskExecution);
        if (this.taskExecutionListeners != null) {
            try {
                for (TaskExecutionListener taskExecutionListener : this.taskExecutionListeners) {
                    taskExecutionListener.onTaskFailed(listenerTaskExecution, throwable);
                }
            }
            catch (Throwable listenerException) {
                this.listenerFailed = true;
                String errorMessage = StringUtils.hasText((String)listenerTaskExecution.getErrorMessage()) ? String.format("%s :While handling this error: %s", listenerException.getMessage(), listenerTaskExecution.getErrorMessage()) : listenerTaskExecution.getErrorMessage();
                logger.error((Object)errorMessage);
                listenerTaskExecution.setErrorMessage(errorMessage);
                listenerTaskExecution.setExitCode(1);
            }
        }
        return listenerTaskExecution;
    }

    private TaskExecution getTaskExecutionCopy(TaskExecution taskExecution) {
        Date startTime = new Date(taskExecution.getStartTime().getTime());
        Date endTime = taskExecution.getEndTime() == null ? null : new Date(taskExecution.getEndTime().getTime());
        return new TaskExecution(taskExecution.getExecutionId(), taskExecution.getExitCode(), taskExecution.getTaskName(), startTime, endTime, taskExecution.getExitMessage(), Collections.unmodifiableList(taskExecution.getArguments()), taskExecution.getErrorMessage(), taskExecution.getExternalExecutionId());
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        Assert.notNull((Object)callback, (String)"A callback is required");
        this.stop();
        callback.run();
    }

    public void start() {
        this.doTaskStart();
        this.started = true;
    }

    public void stop() {
        this.doTaskEnd();
    }

    public boolean isRunning() {
        return this.started;
    }

    public int getPhase() {
        return 0;
    }

    public void destroy() {
    }
}

