/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.properties;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitBindingProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitConsumerProperties;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitProducerProperties;

@ConfigurationProperties(value="spring.cloud.stream.rabbit")
public class RabbitExtendedBindingProperties
implements ExtendedBindingProperties<RabbitConsumerProperties, RabbitProducerProperties> {
    private Map<String, RabbitBindingProperties> bindings = new HashMap<String, RabbitBindingProperties>();

    public Map<String, RabbitBindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, RabbitBindingProperties> bindings) {
        this.bindings = bindings;
    }

    public synchronized RabbitConsumerProperties getExtendedConsumerProperties(String channelName) {
        RabbitConsumerProperties properties;
        if (this.bindings.containsKey(channelName)) {
            if (this.bindings.get(channelName).getConsumer() != null) {
                properties = this.bindings.get(channelName).getConsumer();
            } else {
                properties = new RabbitConsumerProperties();
                this.bindings.get(channelName).setConsumer(properties);
            }
        } else {
            properties = new RabbitConsumerProperties();
            RabbitBindingProperties rbp = new RabbitBindingProperties();
            rbp.setConsumer(properties);
            this.bindings.put(channelName, rbp);
        }
        return properties;
    }

    public synchronized RabbitProducerProperties getExtendedProducerProperties(String channelName) {
        RabbitProducerProperties properties;
        if (this.bindings.containsKey(channelName)) {
            if (this.bindings.get(channelName).getProducer() != null) {
                properties = this.bindings.get(channelName).getProducer();
            } else {
                properties = new RabbitProducerProperties();
                this.bindings.get(channelName).setProducer(properties);
            }
        } else {
            properties = new RabbitProducerProperties();
            RabbitBindingProperties rbp = new RabbitBindingProperties();
            rbp.setProducer(properties);
            this.bindings.put(channelName, rbp);
        }
        return properties;
    }
}

