/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.admin;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.springframework.cloud.stream.binder.rabbit.admin.RabbitAdminException;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public abstract class RabbitManagementUtils {
    public static RestTemplate buildRestTemplate(String adminUri, String user, String password) {
        URI uri;
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(user, password));
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        try {
            uri = new URI(adminUri);
        }
        catch (URISyntaxException e) {
            throw new RabbitAdminException("Invalid URI", e);
        }
        authCache.put(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()), (AuthScheme)basicAuth);
        final HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient){

            protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
                return localContext;
            }
        });
        restTemplate.setMessageConverters(Collections.singletonList(new MappingJackson2HttpMessageConverter()));
        return restTemplate;
    }
}

