/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.utils;

import java.io.UnsupportedEncodingException;

public final class KafkaTopicUtils {
    private KafkaTopicUtils() {
    }

    public static void validateTopicName(String topicName) {
        try {
            byte[] utf8;
            for (byte b : utf8 = topicName.getBytes("UTF-8")) {
                if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 46 || b == 45 || b == 95) continue;
                throw new IllegalArgumentException("Topic name can only have ASCII alphanumerics, '.', '_' and '-', but was: '" + topicName + "'");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

