/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.properties;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBindingProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaProducerProperties;

@ConfigurationProperties(value="spring.cloud.stream.kafka")
public class KafkaExtendedBindingProperties
implements ExtendedBindingProperties<KafkaConsumerProperties, KafkaProducerProperties> {
    private Map<String, KafkaBindingProperties> bindings = new HashMap<String, KafkaBindingProperties>();

    public Map<String, KafkaBindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, KafkaBindingProperties> bindings) {
        this.bindings = bindings;
    }

    public synchronized KafkaConsumerProperties getExtendedConsumerProperties(String channelName) {
        if (this.bindings.containsKey(channelName)) {
            if (this.bindings.get(channelName).getConsumer() != null) {
                return this.bindings.get(channelName).getConsumer();
            }
            KafkaConsumerProperties properties = new KafkaConsumerProperties();
            this.bindings.get(channelName).setConsumer(properties);
            return properties;
        }
        KafkaConsumerProperties properties = new KafkaConsumerProperties();
        KafkaBindingProperties rbp = new KafkaBindingProperties();
        rbp.setConsumer(properties);
        this.bindings.put(channelName, rbp);
        return properties;
    }

    public synchronized KafkaProducerProperties getExtendedProducerProperties(String channelName) {
        if (this.bindings.containsKey(channelName)) {
            if (this.bindings.get(channelName).getProducer() != null) {
                return this.bindings.get(channelName).getProducer();
            }
            KafkaProducerProperties properties = new KafkaProducerProperties();
            this.bindings.get(channelName).setProducer(properties);
            return properties;
        }
        KafkaProducerProperties properties = new KafkaProducerProperties();
        KafkaBindingProperties rbp = new KafkaBindingProperties();
        rbp.setProducer(properties);
        this.bindings.put(channelName, rbp);
        return properties;
    }
}

