/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.properties;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.kafka.KafkaProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.cloud.stream.binder.kafka.properties.JaasLoginModuleConfiguration;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaProducerProperties;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.cloud.stream.kafka.binder")
public class KafkaBinderConfigurationProperties {
    private static final String DEFAULT_KAFKA_CONNECTION_STRING = "localhost:9092";
    private final Transaction transaction = new Transaction();
    @Autowired
    private KafkaProperties kafkaProperties;
    private String[] zkNodes = new String[]{"localhost"};
    private Map<String, String> configuration = new HashMap<String, String>();
    private String defaultZkPort = "2181";
    private String[] brokers = new String[]{"localhost"};
    private String defaultBrokerPort = "9092";
    private String[] headers = new String[0];
    private int offsetUpdateTimeWindow = 10000;
    private int offsetUpdateCount;
    private int offsetUpdateShutdownTimeout = 2000;
    private int maxWait = 100;
    private boolean autoCreateTopics = true;
    private boolean autoAddPartitions;
    private int socketBufferSize = 0x200000;
    private int zkSessionTimeout = 10000;
    private int zkConnectionTimeout = 10000;
    private String requiredAcks = "1";
    private short replicationFactor = 1;
    private int fetchSize = 0x100000;
    private int minPartitionCount = 1;
    private int queueSize = 8192;
    private int healthTimeout = 60;
    private JaasLoginModuleConfiguration jaas;
    private String headerMapperBeanName;

    public Transaction getTransaction() {
        return this.transaction;
    }

    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    @Deprecated
    public String getZkConnectionString() {
        return this.toConnectionString(this.zkNodes, this.defaultZkPort);
    }

    public String getKafkaConnectionString() {
        return this.toConnectionString(this.brokers, this.defaultBrokerPort);
    }

    public String getDefaultKafkaConnectionString() {
        return DEFAULT_KAFKA_CONNECTION_STRING;
    }

    public String[] getHeaders() {
        return this.headers;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public int getOffsetUpdateTimeWindow() {
        return this.offsetUpdateTimeWindow;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public int getOffsetUpdateCount() {
        return this.offsetUpdateCount;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public int getOffsetUpdateShutdownTimeout() {
        return this.offsetUpdateShutdownTimeout;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="No longer necessary since 2.0")
    public String[] getZkNodes() {
        return this.zkNodes;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="No longer necessary since 2.0")
    public void setZkNodes(String ... zkNodes) {
        this.zkNodes = zkNodes;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="No longer necessary since 2.0")
    public void setDefaultZkPort(String defaultZkPort) {
        this.defaultZkPort = defaultZkPort;
    }

    public String[] getBrokers() {
        return this.brokers;
    }

    public void setBrokers(String ... brokers) {
        this.brokers = brokers;
    }

    public void setDefaultBrokerPort(String defaultBrokerPort) {
        this.defaultBrokerPort = defaultBrokerPort;
    }

    public void setHeaders(String ... headers) {
        this.headers = headers;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public void setOffsetUpdateTimeWindow(int offsetUpdateTimeWindow) {
        this.offsetUpdateTimeWindow = offsetUpdateTimeWindow;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public void setOffsetUpdateCount(int offsetUpdateCount) {
        this.offsetUpdateCount = offsetUpdateCount;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public void setOffsetUpdateShutdownTimeout(int offsetUpdateShutdownTimeout) {
        this.offsetUpdateShutdownTimeout = offsetUpdateShutdownTimeout;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="No longer necessary since 2.0")
    public int getZkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="No longer necessary since 2.0")
    public void setZkSessionTimeout(int zkSessionTimeout) {
        this.zkSessionTimeout = zkSessionTimeout;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="No longer necessary since 2.0")
    public int getZkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="No longer necessary since 2.0")
    public void setZkConnectionTimeout(int zkConnectionTimeout) {
        this.zkConnectionTimeout = zkConnectionTimeout;
    }

    private String toConnectionString(String[] hosts, String defaultPort) {
        Object[] fullyFormattedHosts = new String[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            fullyFormattedHosts[i] = hosts[i].contains(":") || StringUtils.isEmpty((Object)defaultPort) ? hosts[i] : hosts[i] + ":" + defaultPort;
        }
        return StringUtils.arrayToCommaDelimitedString((Object[])fullyFormattedHosts);
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public int getMaxWait() {
        return this.maxWait;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public String getRequiredAcks() {
        return this.requiredAcks;
    }

    public void setRequiredAcks(int requiredAcks) {
        this.requiredAcks = String.valueOf(requiredAcks);
    }

    public void setRequiredAcks(String requiredAcks) {
        this.requiredAcks = requiredAcks;
    }

    public short getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(short replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMinPartitionCount() {
        return this.minPartitionCount;
    }

    public void setMinPartitionCount(int minPartitionCount) {
        this.minPartitionCount = minPartitionCount;
    }

    public int getHealthTimeout() {
        return this.healthTimeout;
    }

    public void setHealthTimeout(int healthTimeout) {
        this.healthTimeout = healthTimeout;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public int getQueueSize() {
        return this.queueSize;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0")
    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public boolean isAutoCreateTopics() {
        return this.autoCreateTopics;
    }

    public void setAutoCreateTopics(boolean autoCreateTopics) {
        this.autoCreateTopics = autoCreateTopics;
    }

    public boolean isAutoAddPartitions() {
        return this.autoAddPartitions;
    }

    public void setAutoAddPartitions(boolean autoAddPartitions) {
        this.autoAddPartitions = autoAddPartitions;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0, set properties such as this via 'configuration'")
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Deprecated
    @DeprecatedConfigurationProperty(reason="Not used since 2.0, set properties such as this via 'configuration'")
    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public Map<String, Object> getConsumerConfiguration() {
        HashMap<String, String> consumerConfiguration = new HashMap<String, String>();
        if (this.kafkaProperties != null) {
            consumerConfiguration.putAll(this.kafkaProperties.buildConsumerProperties());
        }
        for (Map.Entry<String, String> configurationEntry : this.configuration.entrySet()) {
            if (!ConsumerConfig.configNames().contains(configurationEntry.getKey())) continue;
            consumerConfiguration.put(configurationEntry.getKey(), configurationEntry.getValue());
        }
        if (ObjectUtils.isEmpty(consumerConfiguration.get("bootstrap.servers"))) {
            consumerConfiguration.put("bootstrap.servers", this.getKafkaConnectionString());
        } else {
            List bootStrapServers;
            Object boostrapServersConfig = consumerConfiguration.get("bootstrap.servers");
            if (boostrapServersConfig instanceof List && (bootStrapServers = (List)consumerConfiguration.get("bootstrap.servers")).size() == 1 && ((String)bootStrapServers.get(0)).equals(DEFAULT_KAFKA_CONNECTION_STRING)) {
                consumerConfiguration.put("bootstrap.servers", this.getKafkaConnectionString());
            }
        }
        return Collections.unmodifiableMap(consumerConfiguration);
    }

    public Map<String, Object> getProducerConfiguration() {
        HashMap<String, String> producerConfiguration = new HashMap<String, String>();
        if (this.kafkaProperties != null) {
            producerConfiguration.putAll(this.kafkaProperties.buildProducerProperties());
        }
        for (Map.Entry<String, String> configurationEntry : this.configuration.entrySet()) {
            if (!ProducerConfig.configNames().contains(configurationEntry.getKey())) continue;
            producerConfiguration.put(configurationEntry.getKey(), configurationEntry.getValue());
        }
        if (ObjectUtils.isEmpty(producerConfiguration.get("bootstrap.servers"))) {
            producerConfiguration.put("bootstrap.servers", this.getKafkaConnectionString());
        } else {
            List bootStrapServers;
            Object boostrapServersConfig = producerConfiguration.get("bootstrap.servers");
            if (boostrapServersConfig instanceof List && (bootStrapServers = (List)producerConfiguration.get("bootstrap.servers")).size() == 1 && ((String)bootStrapServers.get(0)).equals(DEFAULT_KAFKA_CONNECTION_STRING)) {
                producerConfiguration.put("bootstrap.servers", this.getKafkaConnectionString());
            }
        }
        return Collections.unmodifiableMap(producerConfiguration);
    }

    public JaasLoginModuleConfiguration getJaas() {
        return this.jaas;
    }

    public void setJaas(JaasLoginModuleConfiguration jaas) {
        this.jaas = jaas;
    }

    public String getHeaderMapperBeanName() {
        return this.headerMapperBeanName;
    }

    public void setHeaderMapperBeanName(String headerMapperBeanName) {
        this.headerMapperBeanName = headerMapperBeanName;
    }

    public static class Transaction {
        private final KafkaProducerProperties producer = new KafkaProducerProperties();
        private String transactionIdPrefix;

        public String getTransactionIdPrefix() {
            return this.transactionIdPrefix;
        }

        public void setTransactionIdPrefix(String transactionIdPrefix) {
            this.transactionIdPrefix = transactionIdPrefix;
        }

        public KafkaProducerProperties getProducer() {
            return this.producer;
        }
    }
}

