/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.properties;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBindingProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaProducerProperties;

@ConfigurationProperties(value="spring.cloud.stream.kafka")
public class KafkaExtendedBindingProperties
implements ExtendedBindingProperties<KafkaConsumerProperties, KafkaProducerProperties> {
    private Map<String, KafkaBindingProperties> bindings = new HashMap<String, KafkaBindingProperties>();

    public Map<String, KafkaBindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, KafkaBindingProperties> bindings) {
        this.bindings = bindings;
    }

    public KafkaConsumerProperties getExtendedConsumerProperties(String channelName) {
        if (this.bindings.containsKey(channelName) && this.bindings.get(channelName).getConsumer() != null) {
            return this.bindings.get(channelName).getConsumer();
        }
        return new KafkaConsumerProperties();
    }

    public KafkaProducerProperties getExtendedProducerProperties(String channelName) {
        if (this.bindings.containsKey(channelName) && this.bindings.get(channelName).getProducer() != null) {
            return this.bindings.get(channelName).getProducer();
        }
        return new KafkaProducerProperties();
    }
}

