/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.admin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import kafka.utils.ZkUtils;
import org.springframework.cloud.stream.binder.kafka.admin.AdminUtilsOperation;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import scala.collection.Seq;

public class Kafka09AdminUtilsOperation
implements AdminUtilsOperation {
    private static Class<?> ADMIN_UTIL_CLASS;

    @Override
    public void invokeAddPartitions(ZkUtils zkUtils, String topic, int numPartitions, String replicaAssignmentStr, boolean checkBrokerAvailable) {
        try {
            Method[] declaredMethods = ADMIN_UTIL_CLASS.getDeclaredMethods();
            Method addPartitions = null;
            for (Method m : declaredMethods) {
                if (!m.getName().equals("addPartitions")) continue;
                addPartitions = m;
            }
            if (addPartitions == null) {
                throw new InvocationTargetException(new RuntimeException("method not found"));
            }
            addPartitions.invoke(null, zkUtils, topic, numPartitions, replicaAssignmentStr, checkBrokerAvailable);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
    }

    @Override
    public short errorCodeFromTopicMetadata(String topic, ZkUtils zkUtils) {
        try {
            Method fetchTopicMetadataFromZk = ReflectionUtils.findMethod(ADMIN_UTIL_CLASS, (String)"fetchTopicMetadataFromZk", (Class[])new Class[]{String.class, ZkUtils.class});
            Object result = fetchTopicMetadataFromZk.invoke(null, topic, zkUtils);
            Class topicMetadataClass = ClassUtils.forName((String)"kafka.api.TopicMetadata", null);
            Method errorCodeMethod = ReflectionUtils.findMethod((Class)topicMetadataClass, (String)"errorCode");
            return (Short)errorCodeMethod.invoke(result, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AdminUtils class not found", e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return 0;
    }

    @Override
    public int partitionSize(String topic, ZkUtils zkUtils) {
        try {
            Method fetchTopicMetadataFromZk = ReflectionUtils.findMethod(ADMIN_UTIL_CLASS, (String)"fetchTopicMetadataFromZk", (Class[])new Class[]{String.class, ZkUtils.class});
            Object result = fetchTopicMetadataFromZk.invoke(null, topic, zkUtils);
            Class topicMetadataClass = ClassUtils.forName((String)"kafka.api.TopicMetadata", null);
            Method partitionsMetadata = ReflectionUtils.findMethod((Class)topicMetadataClass, (String)"partitionsMetadata");
            Seq partitionSize = (Seq)partitionsMetadata.invoke(result, new Object[0]);
            return partitionSize.size();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AdminUtils class not found", e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return 0;
    }

    @Override
    public void invokeCreateTopic(ZkUtils zkUtils, String topic, int partitions, int replicationFactor, Properties topicConfig) {
        try {
            Method[] declaredMethods = ADMIN_UTIL_CLASS.getDeclaredMethods();
            Method createTopic = null;
            for (Method m : declaredMethods) {
                if (!m.getName().equals("createTopic")) continue;
                createTopic = m;
                break;
            }
            if (createTopic == null) {
                throw new InvocationTargetException(new RuntimeException("method not found"));
            }
            createTopic.invoke(null, zkUtils, topic, partitions, replicationFactor, topicConfig);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.handleInvocationTargetException((InvocationTargetException)e);
        }
        catch (IllegalAccessException e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
    }

    static {
        try {
            ADMIN_UTIL_CLASS = ClassUtils.forName((String)"kafka.admin.AdminUtils", null);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("AdminUtils class not found", e);
        }
    }
}

