/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.stream.binder.BinderException;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.DefaultPollableMessageSource;
import org.springframework.cloud.stream.binder.JavaClassMimeTypeUtils;
import org.springframework.cloud.stream.binder.PartitionHandler;
import org.springframework.cloud.stream.binder.PartitionKeyExtractorStrategy;
import org.springframework.cloud.stream.binder.PartitionSelectorStrategy;
import org.springframework.cloud.stream.binder.PollableMessageSource;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binding.MessageChannelAndSourceConfigurer;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.expression.EvaluationContext;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.support.MessageBuilderFactory;
import org.springframework.integration.support.MutableMessageBuilderFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MessageConverterConfigurer
implements MessageChannelAndSourceConfigurer,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final MessageBuilderFactory messageBuilderFactory = new MutableMessageBuilderFactory();
    private final CompositeMessageConverterFactory compositeMessageConverterFactory;
    private final BindingServiceProperties bindingServiceProperties;
    private ConfigurableListableBeanFactory beanFactory;
    private final Field headersField;

    public MessageConverterConfigurer(BindingServiceProperties bindingServiceProperties, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        Assert.notNull((Object)compositeMessageConverterFactory, (String)"The message converter factory cannot be null");
        this.bindingServiceProperties = bindingServiceProperties;
        this.compositeMessageConverterFactory = compositeMessageConverterFactory;
        this.headersField = ReflectionUtils.findField(MessageHeaders.class, (String)"headers");
        this.headersField.setAccessible(true);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    @Override
    public void configureInputChannel(MessageChannel messageChannel, String channelName) {
        this.configureMessageChannel(messageChannel, channelName, true);
    }

    @Override
    public void configureOutputChannel(MessageChannel messageChannel, String channelName) {
        this.configureMessageChannel(messageChannel, channelName, false);
    }

    @Override
    public void configurePolledMessageSource(PollableMessageSource binding, String name) {
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(name);
        String contentType = bindingProperties.getContentType();
        ConsumerProperties consumerProperties = bindingProperties.getConsumer();
        if ((consumerProperties == null || !consumerProperties.isUseNativeDecoding()) && binding instanceof DefaultPollableMessageSource) {
            ((DefaultPollableMessageSource)binding).addInterceptor(new InboundContentTypeEnhancingInterceptor(contentType));
        }
    }

    private void configureMessageChannel(MessageChannel channel, String channelName, boolean inbound) {
        ConsumerProperties consumerProperties;
        Assert.isAssignable(AbstractMessageChannel.class, channel.getClass());
        AbstractMessageChannel messageChannel = (AbstractMessageChannel)channel;
        BindingProperties bindingProperties = this.bindingServiceProperties.getBindingProperties(channelName);
        String contentType = bindingProperties.getContentType();
        ProducerProperties producerProperties = bindingProperties.getProducer();
        if (!inbound && producerProperties != null && producerProperties.isPartitioned()) {
            messageChannel.addInterceptor((ChannelInterceptor)new PartitioningInterceptor(bindingProperties, this.getPartitionKeyExtractorStrategy(producerProperties), this.getPartitionSelectorStrategy(producerProperties)));
        }
        if (this.isNativeEncodingNotSet(producerProperties, consumerProperties = bindingProperties.getConsumer(), inbound)) {
            if (inbound) {
                messageChannel.addInterceptor((ChannelInterceptor)new InboundContentTypeEnhancingInterceptor(contentType));
            } else {
                messageChannel.addInterceptor((ChannelInterceptor)new OutboundContentTypeConvertingInterceptor(contentType, this.compositeMessageConverterFactory.getMessageConverterForAllRegistered()));
            }
        }
    }

    private boolean isNativeEncodingNotSet(ProducerProperties producerProperties, ConsumerProperties consumerProperties, boolean input) {
        if (input) {
            return consumerProperties == null || !consumerProperties.isUseNativeDecoding();
        }
        return producerProperties == null || !producerProperties.isUseNativeEncoding();
    }

    private PartitionKeyExtractorStrategy getPartitionKeyExtractorStrategy(ProducerProperties producerProperties) {
        PartitionKeyExtractorStrategy partitionKeyExtractor;
        if (producerProperties.getPartitionKeyExtractorClass() != null) {
            this.logger.warn((Object)"'partitionKeyExtractorClass' option is deprecated as of v2.0. Please configure partition key extractor as a @Bean that implements 'PartitionKeyExtractorStrategy'. Additionally you can specify 'spring.cloud.stream.bindings.output.producer.partitionKeyExtractorName' to specify which bean to use in the event there are more then one.");
            partitionKeyExtractor = this.instantiate(producerProperties.getPartitionKeyExtractorClass(), PartitionKeyExtractorStrategy.class);
        } else if (StringUtils.hasText((String)producerProperties.getPartitionKeyExtractorName())) {
            partitionKeyExtractor = (PartitionKeyExtractorStrategy)this.beanFactory.getBean(producerProperties.getPartitionKeyExtractorName(), PartitionKeyExtractorStrategy.class);
            Assert.notNull((Object)partitionKeyExtractor, (String)("PartitionKeyExtractorStrategy bean with the name '" + producerProperties.getPartitionKeyExtractorName() + "' can not be found. Has it been configured (e.g., @Bean)?"));
        } else {
            Map extractors = this.beanFactory.getBeansOfType(PartitionKeyExtractorStrategy.class);
            Assert.isTrue((extractors.size() <= 1 ? 1 : 0) != 0, (String)("Multiple  beans of type 'PartitionKeyExtractorStrategy' found. " + extractors + ". Please use 'spring.cloud.stream.bindings.output.producer.partitionKeyExtractorName' property to specify the name of the bean to be used."));
            partitionKeyExtractor = CollectionUtils.isEmpty((Map)extractors) ? null : (PartitionKeyExtractorStrategy)extractors.values().iterator().next();
        }
        return partitionKeyExtractor;
    }

    private PartitionSelectorStrategy getPartitionSelectorStrategy(ProducerProperties producerProperties) {
        PartitionSelectorStrategy partitionSelector;
        if (producerProperties.getPartitionSelectorClass() != null) {
            this.logger.warn((Object)"'partitionSelectorClass' option is deprecated as of v2.0. Please configure partition selector as a @Bean that implements 'PartitionSelectorStrategy'. Additionally you can specify 'spring.cloud.stream.bindings.output.producer.partitionSelectorName' to specify which bean to use in the event there are more then one.");
            partitionSelector = this.instantiate(producerProperties.getPartitionSelectorClass(), PartitionSelectorStrategy.class);
        } else if (StringUtils.hasText((String)producerProperties.getPartitionSelectorName())) {
            partitionSelector = (PartitionSelectorStrategy)this.beanFactory.getBean(producerProperties.getPartitionSelectorName(), PartitionSelectorStrategy.class);
            Assert.notNull((Object)partitionSelector, (String)("PartitionSelectorStrategy bean with the name '" + producerProperties.getPartitionSelectorName() + "' can not be found. Has it been configured (e.g., @Bean)?"));
        } else {
            Map selectors = this.beanFactory.getBeansOfType(PartitionSelectorStrategy.class);
            Assert.isTrue((selectors.size() <= 1 ? 1 : 0) != 0, (String)("Multiple  beans of type 'PartitionSelectorStrategy' found. " + selectors + ". Please use 'spring.cloud.stream.bindings.output.producer.partitionSelectorName' property to specify the name of the bean to be used."));
            partitionSelector = CollectionUtils.isEmpty((Map)selectors) ? new DefaultPartitionSelector() : (PartitionSelectorStrategy)selectors.values().iterator().next();
        }
        return partitionSelector;
    }

    private <T> T instantiate(Class<?> implClass, Class<T> type) {
        try {
            return (T)implClass.newInstance();
        }
        catch (Exception e) {
            throw new BinderException("Failed to instantiate class: " + implClass.getName(), e);
        }
    }

    public final class PartitioningInterceptor
    implements ChannelInterceptor {
        private final BindingProperties bindingProperties;
        private final PartitionHandler partitionHandler;

        PartitioningInterceptor(BindingProperties bindingProperties, PartitionKeyExtractorStrategy partitionKeyExtractorStrategy, PartitionSelectorStrategy partitionSelectorStrategy) {
            this.bindingProperties = bindingProperties;
            this.partitionHandler = new PartitionHandler((EvaluationContext)ExpressionUtils.createStandardEvaluationContext((BeanFactory)MessageConverterConfigurer.this.beanFactory), this.bindingProperties.getProducer(), partitionKeyExtractorStrategy, partitionSelectorStrategy);
        }

        public void setPartitionCount(int partitionCount) {
            this.partitionHandler.setPartitionCount(partitionCount);
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            if (!message.getHeaders().containsKey((Object)"scst_partitionOverride")) {
                int partition = this.partitionHandler.determinePartition(message);
                return MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("scst_partition", (Object)partition).build();
            }
            return MessageConverterConfigurer.this.messageBuilderFactory.fromMessage(message).setHeader("scst_partition", message.getHeaders().get((Object)"scst_partitionOverride")).removeHeader("scst_partitionOverride").build();
        }
    }

    private abstract class AbstractContentTypeInterceptor
    implements ChannelInterceptor {
        final MimeType mimeType;

        private AbstractContentTypeInterceptor(String contentType) {
            this.mimeType = MessageConverterUtils.getMimeType(contentType);
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            return message instanceof ErrorMessage ? message : this.doPreSend(message, channel);
        }

        protected abstract Message<?> doPreSend(Message<?> var1, MessageChannel var2);
    }

    private final class OutboundContentTypeConvertingInterceptor
    extends AbstractContentTypeInterceptor {
        private final MessageConverter messageConverter;

        private OutboundContentTypeConvertingInterceptor(String contentType, CompositeMessageConverter messageConverter) {
            super(contentType);
            this.messageConverter = messageConverter;
        }

        @Override
        public Message<?> doPreSend(Message<?> message, MessageChannel channel) {
            Message outboundMessage;
            String ct;
            String oct = message.getHeaders().containsKey((Object)"contentType") ? message.getHeaders().get((Object)"contentType").toString() : null;
            String string = ct = message.getPayload() instanceof String ? (ct = JavaClassMimeTypeUtils.mimeTypeFromObject(message.getPayload(), ObjectUtils.nullSafeToString((Object)oct)).toString()) : oct;
            if (!message.getHeaders().containsKey((Object)"contentType")) {
                Map headersMap = (Map)ReflectionUtils.getField((Field)MessageConverterConfigurer.this.headersField, (Object)message.getHeaders());
                headersMap.put("contentType", this.mimeType);
            }
            Message message2 = outboundMessage = message.getPayload() instanceof byte[] ? message : this.messageConverter.toMessage(message.getPayload(), message.getHeaders());
            if (outboundMessage == null) {
                throw new IllegalStateException("Failed to convert message: '" + message + "' to outbound message.");
            }
            if (ct != null && !ct.equals(oct) && oct != null) {
                Map headersMap = (Map)ReflectionUtils.getField((Field)MessageConverterConfigurer.this.headersField, (Object)outboundMessage.getHeaders());
                headersMap.put("contentType", MimeType.valueOf((String)ct));
                headersMap.put("originalContentType", MimeType.valueOf((String)oct));
            }
            return outboundMessage;
        }
    }

    private final class InboundContentTypeEnhancingInterceptor
    extends AbstractContentTypeInterceptor {
        private InboundContentTypeEnhancingInterceptor(String contentType) {
            super(contentType);
        }

        @Override
        public Message<?> doPreSend(Message<?> message, MessageChannel channel) {
            Map headersMap = (Map)ReflectionUtils.getField((Field)MessageConverterConfigurer.this.headersField, (Object)message.getHeaders());
            MimeType contentType = this.mimeType;
            if (message.getHeaders().containsKey((Object)"originalContentType")) {
                Object ct = message.getHeaders().get((Object)"originalContentType");
                contentType = ct instanceof String ? MimeType.valueOf((String)((String)ct)) : (ct == null ? this.mimeType : (MimeType)ct);
                headersMap.put("contentType", contentType);
                headersMap.remove("originalContentType");
            }
            if (!message.getHeaders().containsKey((Object)"contentType")) {
                headersMap.put("contentType", contentType);
            } else if (message.getHeaders().get((Object)"contentType") instanceof String) {
                headersMap.put("contentType", MimeType.valueOf((String)((String)message.getHeaders().get((Object)"contentType"))));
            }
            return message;
        }
    }

    private static class DefaultPartitionSelector
    implements PartitionSelectorStrategy {
        private DefaultPartitionSelector() {
        }

        @Override
        public int selectPartition(Object key, int partitionCount) {
            int hashCode = key.hashCode();
            if (hashCode == Integer.MIN_VALUE) {
                hashCode = 0;
            }
            return Math.abs(hashCode);
        }
    }
}

