/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.core.convert.converter.Converter;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.config.IntegrationConverter;

@Configuration
@Role(value=2)
public class SpelExpressionConverterConfiguration {
    @Bean
    @ConfigurationPropertiesBinding
    @IntegrationConverter
    public Converter<String, Expression> spelConverter() {
        return new SpelConverter();
    }

    public static class SpelConverter
    implements Converter<String, Expression> {
        private SpelExpressionParser parser = new SpelExpressionParser();
        @Autowired
        @Qualifier(value="integrationEvaluationContext")
        @Lazy
        private EvaluationContext evaluationContext;

        public Expression convert(String source) {
            try {
                Expression expression = this.parser.parseExpression(source);
                if (expression instanceof SpelExpression) {
                    ((SpelExpression)expression).setEvaluationContext(this.evaluationContext);
                }
                return expression;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Could not convert '%s' into a SpEL expression", source), e);
            }
        }
    }
}

